//+------------------------------------------------------------------+
//|                                                     3DSpiral.mq5 |
//|                        Copyright 2020, MetaQuotes Software Corp. |
//|                         https://www.mql5.com/en/users/nikolay7ko |
//+------------------------------------------------------------------+
#property copyright "Copyright 2018, Nikolay Semko"
#property link      "https://www.mql5.com/ru/users/nikolay7ko"
#property link      "SemkoNV@bk.ru"
#property version   "1.00"
#property indicator_chart_window
#include <Canvas\iCanvas.mqh> //https://www.mql5.com/ru/code/22164

input int N = 50; // total circles

double cl[];
int Size;
double max, min;
double _r;
int per=0;
double SIN[],COS[];
double K;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnInit() {
   ChartSetInteger(0,CHART_SHOW,false);
   _r=_Height/2-7;
   per=int(2*M_PI*_r);
   ArrayResize(SIN,per);
   ArrayResize(COS,per);
   K=10*_Height;
   for(int i=0; i<per; i++) {
      SIN[i]=sin(i*2*M_PI/per);
      COS[i]=cos(i*2*M_PI/per);
   }
   return(INIT_SUCCEEDED);
}

//+------------------------------------------------------------------+
void OnDeinit(const int reason) {
   ChartSetInteger(0,CHART_SHOW,true);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]) {
   int d=rates_total-prev_calculated;
   if (d>1 || d<0 || Size<10) {
      Size=ArrayCopy(cl,close,0,rates_total-per*N,per*N);
      if (Size>9) {
         max = cl[ArrayMaximum(cl,0)];
         min = cl[ArrayMinimum(cl,0)];
         Canvas.TextColor=0xFFFF55FF;
         Draw();
      }
   } else {
      if (d==1) {
         Size++;
         ArrayResize(cl,Size);
      }
      cl[Size-1]=close[rates_total-1];
      if (d==1) Draw();
   }
   return(rates_total);
}
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam) {
   if (id==CHARTEVENT_MOUSE_MOVE)  Draw();
}
//+------------------------------------------------------------------+
void Draw() {
   ulong t=GetMicrosecondCount();
   int X=_Width/2;
   int Y=_Height/2-5;
   Canvas.Erase(0xFF000000);
   if (max-min<=0) return;
   int nn=0;
   double c=0;
   int _a=(_Width/2  - _MouseX + 5*per)%per;
   int _b=(_Height/2 - _MouseY + 5*per)%per;
   for (int i=0; i<Size; i++) {
      double r = _r*(0.3+0.7*(cl[i]-min)/(max-min));
      int a = i%per;
      double cc=COS[a];
      if (c<0 && cc>=0) nn++;
      c=cc;
      double z =r -r*2*double(i)/Size;
      double x = c*r;
      double y = SIN[a]*r;
      double R=sqrt(x*x+y*y+z*z);
      double x1=x*COS[_a]+z*SIN[_a];
      double z1=-x*SIN[_a]+z*COS[_a];
      double y1=y*COS[_b]+z1*SIN[_b];
      double z2=-y*SIN[_b]+z1*COS[_b];
      z2=z2+_r;
      x=X+K*x1/(z2+K);
      y=Y+K*y1/(z2+K);
      _PixelSet((int)x,(int)y,Grad(double(i)/Size));
   }
   t=GetMicrosecondCount()-t;
   _CommXY(20,30,_Symbol);
   _Comment("Total "+string(nn)+" Circles");
   _Comment("Circle period = " + string(per)+" bars");
   _Comment("Runtime = "+string (t) +" mks");
   Canvas.Update();
}
//+------------------------------------------------------------------+
uint Grad(double p) {
   static uint Col[6]= {0xFF0000FF,0xFFFF00FF,0xFFFF0000,0xFFFFFF00,0xFF00FF00,0xFF00FFFF};
   if(p>0.9999) return Col[5];
   if(p<0.0001) return Col[0];
   p=p*5;
   int n=(int)p;
   double k=p-n;
   argb c1,c2;
   c1.clr=Col[n];
   c2.clr=Col[n+1];
   return ARGB(255,c1.c[2]+uchar(k*(c2.c[2]-c1.c[2])+0.5),
               c1.c[1]+uchar(k*(c2.c[1]-c1.c[1])+0.5),
               c1.c[0]+uchar(k*(c2.c[0]-c1.c[0])+0.5));
}
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
