//+------------------------------------------------------------------+
//|                                                          Monitor |
//|                                 Copyright 2006-2012, FXmaster.de |
//|     programming & support - Alexey Sergeev (profy.mql@gmail.com) |
//+------------------------------------------------------------------+
#property copyright "Copyright 2006-2012, FXmaster.de"
#property link      "profy.mql@gmail.com"

//  
#define ERROR_FILE_NOT_FOUND		2 

// Flag values
#define modeOpen								0 // open mode
#define modeCreate							1 // creare mode

#import "MemMap32.dll"
int MemOpen(string path,int size,int mode,int &err);        // open/create memory-mapped file and returns handle
void MemClose(int hmem);                                    // close memory mapped file
int MemGrows(int hmem,string path,int newsize,int &err);    // increase size of memory-mapped file
int MemWrite(int hmem,int &v[], int pos, int sz, int &err); // write v vector (size bytes) to memory-mapped file starting from position pos
int MemRead(int hmem, int &v[], int pos, int sz, int &err); // read v vector (size bytes) from memory-mapped file starting from position pos
#import

input int MaxLate=500; // miliseconds delay

// memory-mapped file
#define HEAD		8            // size of the header
#define SIZE		12           // vector size (3*int(4))
int hmem,err,price[][3],adr=0; // arrays used for data exchange
string file;                   // name of memory-mapped file

string sID;
string g_inf;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   file="Local\\Monitor_"+StringSubstr(Symbol(),0,(int)MathMin(6,StringLen(Symbol()))); // name of memory-mapped file
   sID="memmapobj."; // appendix for quotes

   int head[2];
   hmem=MemOpen(file,-1,modeOpen,err); // open file
   if(hmem>0) // if opened successfully
     {
      Print("open OK h="+string(hmem));
      int r=MemRead(hmem,head,0,HEAD,err);
      Print("read head uses="+string(head[0])+"  adr="+string(head[1])+"  | r="+string(r)+"  err="+string(err));
      head[0]++;
      head[1]++;
      adr=head[1]; // number of connected apps and folder of the current client terminal
      hmem=MemGrows(hmem,file,HEAD+(adr+1)*SIZE,err);
      Print("grows to "+string(HEAD+(adr+1)*SIZE)+"  | h="+string(hmem)+"  err="+string(err));
      int w=MemWrite(hmem,head,0,HEAD,err);
      Print("write head w="+string(w)+"  err="+string(err));
     }
   else
   if(err==ERROR_FILE_NOT_FOUND) // if file not found, create it
     {
      Print("-err("+string(err)+") memfile not found. Create it...");
      head[0]=1;
      head[1]=0;
      adr=head[1];
      hmem=MemOpen(file,HEAD+(adr+1)*SIZE,modeCreate,err);
      Print("create size="+string(HEAD+(adr+1)*SIZE)+"  h="+string(hmem)+"  err="+string(err));
      if(hmem<=0 || err!=0)
        {
         Print("-err("+string(err)+") create memfile  h="+string(hmem)); return(0);
        }
      else Print("create OK h="+string(hmem));
      int w=MemWrite(hmem,head,0,HEAD,err); Print("write head w="+string(w)+"  err="+string(err));
      if(err!=0)
        {
         Print("-err("+string(err)+") write memfile  h="+string(hmem));
         return(0);
        }
     }
   else
     {
      Print("-unknow err("+string(err)+")  h="+string(hmem));
      return(0);
     }
   Print("OK ("+string(err)+") h="+string(hmem));
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   if(hmem>0) // if handle>0 (file opened)
     {
      int head[2];
      int r=MemRead(hmem,head,0,HEAD,err);
      Print("read head uses="+string(head[0])+"  adr="+string(head[1])+"  | r="+string(r)+"  err="+string(err));
      head[0]--;
      int w=MemWrite(hmem,head,0,HEAD,err);
      Print("write head  w="+string(w)+"  err="+string(err));
      if(head[0]>0) Print("reduce use of memfile "+string(hmem)+"  to "+string(head[0]));
      else
        {
         Print("close memfile "+string(hmem));
         MemClose(hmem);
        }
     }
   ObjectsDeleteAll2(0,-1,sID); // delete all objects
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
   Print("started");
   while(true)
     {
      g_inf="";
      INF("");
      INF("File to "+file,true);
      int w=WritePrice();
      INF("write="+string(w)+"  err="+string(err));
      int c,n=ReadPrice(c);
      if(n==-1) INF("-err read Head");
      if(n==-2) INF("-err read Data");
      int t=(int)GetTickCount();
      INF(TimeToString(TimeLocal(),TIME_MINUTES|TIME_SECONDS)+" || "+string(t));
      INF("-----------------------------------------------------");
      INF("Terminals="+string(n)+"  active="+string(c),true); INF("");
      for(int i=0; i<c; i++)
        {
         int tm=price[i][0];
         int acc=price[i][1];
         double bid=price[i][2]*0.000001;
         INF(string(t-tm)+" ("+string(tm)+") | "+string(acc)+" | "+DTS(bid,6));
         SetHLine(sID+string(i),bid,Lime,1,STYLE_DOT,""); // set lines
        }
      for(int i=c; i<n; i++) ObjectDelete(0,sID+string(i));
      Comment(g_inf);
      if(IsStopped() || !TerminalInfoInteger(TERMINAL_TRADE_ALLOWED))
        {
         Print("stopped");
         break;
        }
      Sleep(100);
     }
  }
//+------------------------------------------------------------------+
//| WritePrice                                                       |
//+------------------------------------------------------------------+
int WritePrice()
  {
   if(hmem<=0) return(0);
   int data[3];
   double Bid=SymbolInfoDouble(Symbol(),SYMBOL_BID);
   data[0]=(int)GetTickCount();
   data[1]=(int)AccountInfoInteger(ACCOUNT_LOGIN);
   data[2]=int(Bid/0.000001);
   int w=MemWrite(hmem,data,HEAD+adr*SIZE,SIZE,err); return(w);
  }
//+------------------------------------------------------------------+
//| ReadPrice                                                        |
//+------------------------------------------------------------------+
int ReadPrice(int &c)
  {
   if(hmem<=0) return(0);
   int data[3],head[2];
   int r=MemRead(hmem,head,0,HEAD,err);
   INF("read head  uses="+string(head[0])+"  adr="+string(head[1])+"  | r="+string(r)+"  err="+string(err));
   if(r<HEAD || err!=0) return(-1);
   int n=head[1]+1;
   ArrayResize(price,0); c=0; // number of terminals
   int t=(int)GetTickCount();
   for(int i=0; i<n; i++)
     {
      ArrayInitialize(data,0);
      r=MemRead(hmem,data,HEAD+i*SIZE,SIZE,err); if(r<SIZE || err!=0) return(-2);
      if(MathAbs(t-data[0])>MaxLate) continue;
      ArrayResize(price,c+1);
      price[c][0]=data[0];
      price[c][1]=data[1];
      price[c][2]=data[2];
      c++;
     }
   return(n);
  }
//+------------------------------------------------------------------+
//| SetHLine                                                         |
//+------------------------------------------------------------------+
void SetHLine(string name,double pr,color clr,int width,int style,string st)
  {
   ObjectCreate(0,name,OBJ_HLINE,0,0,0);
   ObjectSetDouble(0,name,OBJPROP_PRICE,0,pr);
   ObjectSetInteger(0,name,OBJPROP_WIDTH,width);
   ObjectSetInteger(0,name,OBJPROP_COLOR,clr);
   ObjectSetString(0,name,OBJPROP_TEXT,st);
   ObjectSetInteger(0,name,OBJPROP_STYLE,style);
  }
//+------------------------------------------------------------------+
//| INF                                                              |
//+------------------------------------------------------------------+
void INF(string st,bool ini=false)
  {
   if(ini) g_inf=g_inf+"\n        "+st; else g_inf=g_inf+"\n            "+st;
  }
//+------------------------------------------------------------------+
//| DTS                                                              |
//+------------------------------------------------------------------+
string DTS(double d,int n=-1)
  {
   if(d==EMPTY_VALUE) return("<>");
   if(n<0) return(DoubleToString(d,_Digits));
   else return(DoubleToString(d,n));
  }
//+------------------------------------------------------------------+
//| ObjectsDeleteAll2                                                |
//+------------------------------------------------------------------+
void ObjectsDeleteAll2(int wnd=-1,int type=-1,string pref="")
  {
   string names[];
   int n=ObjectsTotal(0);
   ArrayResize(names,n);
   for(int i=0; i<n; i++) names[i]=ObjectName(0, i);
   for(int i=0; i<n; i++)
     {
      if(wnd>=0) if(ObjectFind(0,names[i])!=wnd) continue;
      if(type>=0) if(ObjectGetInteger(0, names[i], OBJPROP_TYPE)!=type) continue;
      if(pref!="") if(StringSubstr(names[i], 0, StringLen(pref))!=pref) continue;
      ObjectDelete(0,names[i]);
     }
  }
//+------------------------------------------------------------------+
