//+------------------------------------------------------------------+
//|                                                 XTrendlessOS.mq5 |
//|                                    Copyright  2010,   LenIFCHIK |
//+------------------------------------------------------------------+
//| Place the SmoothAlgorithms.mqh file                              |
//| to the directory: terminal_data_folder\MQL5\Include              |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, LenIFCHIK"
#property link ""
//---- indicator version
#property version   "1.00"
//---- drawing indicator in a separate window
#property indicator_separate_window
//---- number of indicator buffers 2
#property indicator_buffers 2 
//---- only one plot is used
#property indicator_plots   1
//+----------------------------------------------+
//| Indicator drawing parameters                 |
//+----------------------------------------------+
//---- drawing the indicator as a four-color histogram
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//---- the following colors are used in the histogram
#property indicator_color1 Gray,Lime,Green,Magenta,Red
//---- the indicator line is a continuous curve
#property indicator_style1  STYLE_SOLID
//---- the indicator line width is equal to 3
#property indicator_width1  3
//---- displaying the indicator label
#property indicator_label1  "XTrendlessOS"
//+----------------------------------------------+
//| CXMA class description                       |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//---- declaration of the CXMA class variables from the SmoothAlgorithms.mqh file
CXMA XMA;
//+----------------------------------------------+
//| Declaration of enumerations                  |
//+----------------------------------------------+
enum Applied_price_      // Type of constant
  {
   PRICE_CLOSE_ = 1,     // Close
   PRICE_OPEN_,          // Open
   PRICE_HIGH_,          // High
   PRICE_LOW_,           // Low
   PRICE_MEDIAN_,        // Median Price (HL/2)
   PRICE_TYPICAL_,       // Typical Price (HLC/3)
   PRICE_WEIGHTED_,      // Weighted Close (HLCC/4)
   PRICE_SIMPLE,         // Simple Price (OC/2)
   PRICE_QUARTER_,       // Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  // TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_   // TrendFollow_2 Price 
  };
/*enum Smooth_Method - enumeration is declared in the SmoothAlgorithms.mqh file
  {
   MODE_SMA_,  // SMA
   MODE_EMA_,  // EMA
   MODE_SMMA_, // SMMA
   MODE_LWMA_, // LWMA
   MODE_JJMA,  // JJMA
   MODE_JurX,  // JurX
   MODE_ParMA, // ParMA
   MODE_T3,    // T3
   MODE_VIDYA, // VIDYA
   MODE_AMA,   // AMA
  }; */
enum ENUM_WIDTH // Type of constant
  {
   w_1 = 1,   // 1
   w_2,       // 2
   w_3,       // 3
   w_4,       // 4
   w_5        // 5
  };
//+-----------------------------------+
//|  Indicator input parameters       |
//+-----------------------------------+
input Smooth_Method TMA_Method=MODE_JurX;           // Smoothing method
input int TLength=7;                                // Smoothing depth      
input int TPhase=100;                               // Smoothing parameter
input Applied_price_ IPC=PRICE_CLOSE;               // Price constant
input double OBLevel=0.00473;                       // Overbought level
input double OSLevel=-0.00473;                      // Oversold level 
input color LevelsColor=Blue;                       // Levels color
input ENUM_LINE_STYLE LevelsStyle=STYLE_DASHDOTDOT; // Levels style
input ENUM_WIDTH LevelsWidth=w_1;                   // Day line width
input int Shift=0;                                  // Horizontal shift of the indicator in bars
//+-----------------------------------+
//---- declaration of dynamic arrays that
//---- will be used as indicator buffers
double IndBuffer[],ColorIndBuffer[];
//---- declaration of the integer variables for the start of data calculation
int min_rates_total;
//----
double OBLevel06,OBLevel08,OSLevel06,OSLevel08;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//---- initialization of variables of the start of data calculation
   min_rates_total=XMA.GetStartBars(TMA_Method,TLength,TPhase);
   
//---- setting up alerts for unacceptable values of external variables
   XMA.XMALengthCheck("TLength", TLength);
   XMA.XMAPhaseCheck("TPhase", TPhase, TMA_Method);
   
//---- initialization of variables  
   OBLevel06=0.6*OBLevel;
   OBLevel08=0.8*OBLevel;
   OSLevel06=0.6*OSLevel;
   OSLevel08=0.8*OSLevel;

//---- set IndBuffer[] dynamic array as an indicator buffer
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---- moving the indicator 1 horizontally
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---- performing the shift of the beginning of the indicator drawing
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---- setting the indicator values that won't be visible on a chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);

//---- set ColorIndBuffer[] dynamic array as a colored indicator buffer   
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//---- performing the shift of the beginning of the indicator drawing
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);

//---- initializations of a variable for the indicator short name
   string shortname;
   string Smooth=XMA.GetString_MA_Method(TMA_Method);
   StringConcatenate(shortname,"XTrendlessOS(",TLength,", ",TLength,", ",Smooth,")");
//---- creating a name for displaying in a separate sub-window and in a tooltip
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---- determination of accuracy of displaying the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
   
//---- Bid line drawing parameters   
   IndicatorSetInteger(INDICATOR_LEVELS,4);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,LevelsWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,LevelsWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,2,LevelsWidth);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,3,LevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,3,LevelsStyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,3,LevelsWidth);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,OBLevel06);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,OBLevel08);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,OSLevel06);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,3,OSLevel08);
   
//---- initialization end
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    // number of bars in history at the current tick
                const int prev_calculated,// number of bars calculated at previous call
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---- checking the number of bars to be enough for the calculation
   if(rates_total<min_rates_total) return(0);

//---- declaration of variables with a floating point
   double price_,xma,current;
//---- declaration of integer variables and getting already calculated bars
   int first,bar;

//---- calculation of the 'first' starting index for the bars recalculation loop
   if(prev_calculated>rates_total || prev_calculated<=0) // checking for the first start of the indicator calculation
      first=0;                   // starting index for calculation of all bars
   else first=prev_calculated-1; // starting index for calculation of new bars

//---- main indicator calculation loop
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //---- call of the PriceSeries function to get the input price 'price_'
      price_=PriceSeries(IPC,bar,open,low,high,close);
      xma=XMA.XMASeries(0,prev_calculated,rates_total,TMA_Method,TPhase,TLength,price_,bar,false);
      IndBuffer[bar]=price_-xma;
     }

//---- calculation of the 'first' starting index for the bars recalculation loop
   if(prev_calculated>rates_total || prev_calculated<=0) // checking for the first start of the indicator calculation
      first=min_rates_total;

//---- main loop of the IndBuffer indicator coloring
   for(bar=first; bar<rates_total; bar++)
     {
      ColorIndBuffer[bar]=0;
      current=IndBuffer[bar];
      
      if(current>OBLevel08) ColorIndBuffer[bar]=1; else if(current>OBLevel06) ColorIndBuffer[bar]=2;   
      if(current<OSLevel08) ColorIndBuffer[bar]=3; else if(current<OSLevel06) ColorIndBuffer[bar]=4; 
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
