//+---------------------------------------------------------------------+
//|                                                           XTRIX.mq5 | 
//|                                  Copyright  2006, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       DodgerBlue 
#property indicator_color1 clrDodgerBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "XTRIX"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2,XMA3;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_JJMA;// 
input uint XLength=5;                    //                     
input int XPhase=100;                    // ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input uint Smooth=5;                     //   
input uint Mom_Period=1;                 //momentum  
input Applied_price_ IPC=PRICE_CLOSE_;   // 
input int Shift=0;                       //     
//+----------------------------------------------+
//----   ,    
//      
double IndBuffer[];
//----      
int min_rates_total,min_rates_1,min_rates_2,min_rates_3,MomPeriod;
//----   
int Count[];
double xxlprice[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+   
//| XTRIX indicator initialization function                          | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_1=GetStartBars(XMA_Method,XLength,XPhase);
   min_rates_2=2*min_rates_1;
   min_rates_3=min_rates_2+int(Mom_Period)+1;
   min_rates_total=min_rates_3+GetStartBars(XMA_Method,Smooth,XPhase);
   MomPeriod=int(Mom_Period)+1;
//----       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMALengthCheck("Smooth",Smooth);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----       
   ArrayResize(Count,MomPeriod);
   ArrayResize(xxlprice,MomPeriod);

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"XTRIX(",Smooth1,", ",Smooth,", ",XLength,", ",Mom_Period,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| XTRIX iteration function                                         | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double price,lprice,xlprice,trix;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      ArrayInitialize(Count,0);
      ArrayInitialize(xxlprice,0.0);
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      lprice=MathLog(price);
      xlprice=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,lprice,bar,false);
      xxlprice[Count[0]]=XMA2.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,xlprice,bar,false);
      trix=10000*(xxlprice[Count[0]]-xxlprice[Count[Mom_Period]]);
      IndBuffer[bar]=XMA3.XMASeries(min_rates_3,prev_calculated,rates_total,XMA_Method,XPhase,Smooth,trix,bar,false);
      if(bar<rates_total-1) Recount_ArrayZeroPos(Count,MomPeriod);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
