//+---------------------------------------------------------------------+
//|                                                    VKW_BandsIBS.mq5 | 
//|                                              Copyright  2008, Rosh | 
//|                 http://www.investo.ru/forum/viewtopic.php?t=127513/ | 
//+---------------------------------------------------------------------+
//| Place the SmoothAlgorithms.mqh file                                 |
//| in the directory: terminal_data_folder\MQL5\Include                 |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2008, Rosh"
#property link "http://www.investo.ru/forum/viewtopic.php?t=127513/"
#property description "Internal Bar Strength"
//---- indicator version
#property version   "1.00"
//---- drawing the indicator in a separate window
#property indicator_separate_window
//---- number of indicator buffers
#property indicator_buffers 3 
//---- only three plots are used
#property indicator_plots   3
//+-----------------------------------+
//|  Indicator drawing parameters     |
//+-----------------------------------+
//---- drawing the indicator as a line
#property indicator_type1   DRAW_LINE
//---- DodgerBlue color is used for the indicator line
#property indicator_color1 DodgerBlue
//---- the indicator line is a continuous curve
#property indicator_style1  STYLE_SOLID
//---- indicator line width is equal to 1
#property indicator_width1  1
//---- displaying the indicator label
#property indicator_label1  "Internal Bar Strength"
//+-----------------------------------+
//|  Indicator drawing parameters     |
//+-----------------------------------+
//---- drawing the indicator as a line
#property indicator_type2   DRAW_LINE
//---- DodgerBlue color is used for the indicator line
#property indicator_color2 LimeGreen
//---- the indicator line is a continuous curve
#property indicator_style2  STYLE_SOLID
//---- indicator line width is equal to 2
#property indicator_width2  2
//---- displaying the indicator label
#property indicator_label2  "VKW_Bands Upper"
//+-----------------------------------+
//|  Indicator drawing parameters     |
//+-----------------------------------+
//---- drawing the indicator as a line
#property indicator_type3   DRAW_LINE
//---- DodgerBlue color is used for the indicator line
#property indicator_color3 DeepPink
//---- the indicator line is a continuous curve
#property indicator_style3  STYLE_SOLID
//---- indicator line width is equal to 2
#property indicator_width3  2
//---- displaying the indicator label
#property indicator_label3  "VKW_Bands Lower"
//+-----------------------------------+
//| Levels parameters                 |
//+-----------------------------------+
#property indicator_level1 60
#property indicator_level2 40
#property indicator_levelcolor Magenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+-----------------------------------+
//|  CXMA class description           |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//---- declaration of the CXMA class variables from the SmoothAlgorithms.mqh file
CXMA XMA1,XMA2,XMA3;
//+-----------------------------------+
//|  Declaration of enumerations      |
//+-----------------------------------+
enum Applied_price_     // Type of constant
  {
   PRICE_CLOSE_LOW,     // Close-Low
   PRICE_HIGH_CLOSE     // High-Close
  };
/*enum Smooth_Method - enumeration is declared in the SmoothAlgorithms.mqh file
  {
   MODE_SMA_,  // SMA
   MODE_EMA_,  // EMA
   MODE_SMMA_, // SMMA
   MODE_LWMA_, // LWMA
   MODE_JJMA,  // JJMA
   MODE_JurX,  // JurX
   MODE_ParMA, // ParMA
   MODE_T3,    // T3
   MODE_VIDYA, // VIDYA
   MODE_AMA,   // AMA
  }; */
//+-----------------------------------+
//|  Indicator input parameters       |
//+-----------------------------------+
input Smooth_Method IMA_Method=MODE_SMA;   // IBS smoothing method
input int ILength=5;                       // IBS smoothing depth                    
input int IPhase=15;                       // IBS smoothing parameter
input Applied_price_ IPC=PRICE_HIGH_CLOSE; // IBS applied price
input int IShift=0;                        // Horizontal shift of IBS in bars
input bool IDirect=true;                   // Indicator vertical reverse

extern uint RPeriod=25;                    // Extremum values searching period
input Smooth_Method SmMA_Method=MODE_SMA;  // Smoothing method
input int SLength=3;                       // Smoothing depth
input int SPhase=100;                      // Smoothing parameter
input int SShift=0;                        // Horizontal shift of the channel indicator in bars
//+-----------------------------------+
//---- declaration of dynamic arrays that 
//---- will be used as indicator buffers
double XIBS[],UpVKWB[],DnVKWB[];
//---- declaration of the integer variables for the start of data calculation
int min_rates_total,min_rates_ibs,min_rates_extr;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---- initialization of variables of the start of data calculation
   min_rates_ibs=XMA1.GetStartBars(IMA_Method,ILength,IPhase);
   min_rates_extr=int(min_rates_ibs+RPeriod);
   min_rates_total=min_rates_extr+XMA1.GetStartBars(SmMA_Method,SLength,SPhase);

//---- setting up alerts for unacceptable values of external variables
   XMA1.XMALengthCheck("ILength", ILength);
   XMA1.XMAPhaseCheck("IPhase", IPhase, IMA_Method);
   XMA1.XMALengthCheck("SLength", SLength);
   XMA1.XMAPhaseCheck("SPhase", SPhase, SmMA_Method);

//---- set XIBS[] dynamic array as an indicator buffer
   SetIndexBuffer(0,XIBS,INDICATOR_DATA);
//---- moving the indicator 1 horizontally
   PlotIndexSetInteger(0,PLOT_SHIFT,IShift);
//---- performing the shift of the beginning of the indicator drawing
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_ibs);
//---- setting the indicator values that won't be visible on a chart
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);

//---- set UpVKWB[] dynamic array as an indicator buffer
   SetIndexBuffer(1,UpVKWB,INDICATOR_DATA);
//---- shifting the indicator 2 horizontally
   PlotIndexSetInteger(1,PLOT_SHIFT,SShift);
//---- performing the shift of the beginning of the indicator drawing
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---- setting the indicator values that won't be visible on a chart
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);

//---- set DnVKWB[] dynamic array as an indicator buffer
   SetIndexBuffer(2,DnVKWB,INDICATOR_DATA);
//---- shifting the indicator 3 horizontally
   PlotIndexSetInteger(2,PLOT_SHIFT,SShift);
//---- performing the shift of the beginning of the indicator drawing
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---- setting the indicator values that won't be visible on a chart
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);

//---- initializations of a variable for the indicator short name
   string shortname="VKW_BandsIBS";
//---- creation of the name to be displayed in a separate sub-window and in a tooltip
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---- determination of accuracy of displaying the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---- initialization end
  }
//+------------------------------------------------------------------+ 
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    // number of bars in history at the current tick
                const int prev_calculated,// number of bars calculated at previous call
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---- checking the number of bars to be enough for the calculation
   if(rates_total<min_rates_total) return(0);

//---- declaration of variables with a floating point  
   double range,dprice,ibs,n_max,n_min;
//---- declaration of integer variables and getting already calculated bars
   int first,bar;

//---- calculation of the 'first' starting index for the bars recalculation loop
   if(prev_calculated>rates_total || prev_calculated<=0) // checking for the first start of the indicator calculation
      first=0;                   // starting index for calculation of all bars
   else first=prev_calculated-1; // starting index for calculation of new bars

//---- main indicator calculation loop
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      if(IPC) dprice=close[bar]-low[bar];
      else    dprice=high[bar]-close[bar];

      range=high[bar]-low[bar];

      if(range) ibs=dprice/range;
      else      ibs=dprice/_Point;

      XIBS[bar]=100*XMA1.XMASeries(0,prev_calculated,rates_total,IMA_Method,IPhase,ILength,ibs,bar,false);
      if(!IDirect) XIBS[bar]*=-1;

      if(bar>min_rates_extr+1)
        {
         ArraySetAsSeries(XIBS,true);
         int rate_=rates_total-1-bar;
         n_max=XIBS[ArrayMaximum(XIBS,rate_,RPeriod)];
         n_min=XIBS[ArrayMinimum(XIBS,rate_,RPeriod)];
         ArraySetAsSeries(XIBS,false);
        }

      UpVKWB[bar]=XMA2.XMASeries(min_rates_extr,prev_calculated,rates_total,SmMA_Method,SPhase,SLength,n_max,bar,false);
      DnVKWB[bar]=XMA3.XMASeries(min_rates_extr,prev_calculated,rates_total,SmMA_Method,SPhase,SLength,n_min,bar,false);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
