//+------------------------------------------------------------------+
//|                               Volume_Weighted_MA_Cloud_Digit.mq5 | 
//|                                    Copyright  2011, StatBars TO | 
//|                                      http://ridecrufter.narod.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2011, StatBars TO"
#property link "http://ridecrufter.narod.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    6
#property indicator_buffers 6 
//----     
#property indicator_plots   3
//+------------------------------------------------+
//|                          |
//+------------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
#property indicator_type2   DRAW_FILLING
//----   
#property indicator_color1  clrPaleTurquoise
#property indicator_color2  clrLightPink
//----  
#property indicator_label1  "Upper Cloud"
#property indicator_label2  "Lower Cloud"
//+------------------------------------------------+
//|                    |
//+------------------------------------------------+
//----      
#property indicator_type3   DRAW_COLOR_LINE
//----      
#property indicator_color3  clrMagenta,clrGray,clrBlue
//----   -  
#property indicator_style3  STYLE_SOLID
//----     5
#property indicator_width3  5
//----   
#property indicator_label3  "Volume_Weighted_MA_Digit"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input string  SirName="Volume_Weighted_MA_Cloud_Digit";     //    
input uint Length=12;                                       //                     
input Applied_price_ IPC=PRICE_CLOSE_;                      // 
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;           // 
input int Shift=0;                                          //     
input int PriceShift=0;                                     //c     
input uint Dev=20;                                          //  
input uint Digit=2;                                         //  
input bool ShowPrice=true;                                  //  
//----   
input color  Price_color=clrGray;
//+----------------------------------------------+
//----   ,         
double LineBuffer[];
double ColorLineBuffer[];
double UpCloudBuffer1[],UpCloudBuffer2[];
double DnCloudBuffer1[],DnCloudBuffer2[];
//----      
double dPriceShift;
//----      
int min_rates_total;
double Vol[];
double PointPow10;
//----     
string Price_name;
//+------------------------------------------------------------------+   
//| Volume_Weighted_MA initialization function                       | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(Length);
//----    
   dPriceShift=_Point*PriceShift;
   PointPow10=_Point*MathPow(10,Digit);
//----  
   Price_name=SirName+"Price";
//----       
   ArrayResize(Vol,Length);

//----         
   SetIndexBuffer(0,UpCloudBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,UpCloudBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,DnCloudBuffer1,INDICATOR_DATA);
   SetIndexBuffer(3,DnCloudBuffer2,INDICATOR_DATA);
   SetIndexBuffer(4,LineBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(5,ColorLineBuffer,INDICATOR_COLOR_INDEX);

//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);

//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);

//----      
   string shortname;
   StringConcatenate(shortname,"Volume_Weighted_MA_Cloud_Digit(",Length,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,Price_name);
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+ 
//| Volume_Weighted_MA iteration function                            | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double mov,sum;
//----   
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total-1; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      sum=0.0;
      for(int kkk=int(bar-Length+1); kkk<=bar; kkk++)
        {
         int index=bar-kkk;
         if(VolumeType==VOLUME_TICK) Vol[index]=double(tick_volume[kkk]);
         else Vol[index]=double(volume[kkk]);
         sum+=Vol[index];
        }
      for(int rrr=0; rrr<int(Length); rrr++) Vol[rrr]/=sum;
      mov=0.0;
      for(int kkk=int(bar-Length+1); kkk<=bar; kkk++) mov+=PriceSeries(IPC,kkk,open,low,high,close)*Vol[bar-kkk];
      //----  
      mov+=dPriceShift;
      //----   
      mov=PointPow10*MathRound(mov/PointPow10);
      //----    
      LineBuffer[bar]=UpCloudBuffer2[bar]=DnCloudBuffer1[bar]=mov;
      UpCloudBuffer1[bar]=mov*Dev;
      DnCloudBuffer2[bar]=mov/Dev;
     }
   if(ShowPrice)
     {
      int bar0=rates_total-1;
      datetime time0=time[bar0]+1*PeriodSeconds();
      SetRightPrice(0,Price_name,0,time0,LineBuffer[bar0],Price_color);
     }
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first++;

//----     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      double clr=1;
      double trend=LineBuffer[bar]-LineBuffer[bar-1];
      if(!trend) clr=ColorLineBuffer[bar-1];
      else
        {
         if(trend>0) clr=2;
         if(trend<0) clr=0;
        }
      ColorLineBuffer[bar]=clr;
     }
//----     
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+   
//|                                 |
//+------------------------------------------------------------------+ 
double PriceSeries(uint applied_price,//  
                   uint   bar,//            ).
                   const double &Open[],
                   const double &Low[],
                   const double &High[],
                   const double &Close[])
  {
//----
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);

      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----         
      case 12:
        {
         double res=High[bar]+Low[bar]+Close[bar];
         if(Close[bar]<Open[bar]) res=(res+Low[bar])/2;
         if(Close[bar]>Open[bar]) res=(res+High[bar])/2;
         if(Close[bar]==Open[bar]) res=(res+Close[bar])/2;
         return(((res-Low[bar])+(res-High[bar]))/2);
        }
      //----
      default: return(Close[bar]);
     }
//----
//return(0);
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color              // Text color
                      )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,2);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,// chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color              // Text color
                   )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color);
   else ObjectMove(chart_id,name,0,time,price);
//----
  }
//+------------------------------------------------------------------+
