//+------------------------------------------------------------------+
//|                                                          Taf.mq5 |
//|                               Copyright  2004, Poul_Trade_Forum |
//|                                                         Aborigen |
//|                                          http://forex.kbpauk.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, Poul_Trade_Forum"
#property link      "http://forex.kbpauk.ru/"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1 DRAW_SECTION
//----     
#property indicator_color1 clrDodgerBlue
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----    
#property indicator_label1  "TafHigh"
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type2 DRAW_SECTION
//----     
#property indicator_color2 clrMagenta
//----   - 
#property indicator_style2 STYLE_SOLID
//----     2
#property indicator_width2 2
//----    
#property indicator_label2  "TafLow"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint BQUALIFY=2;
input int Shift=0; //      
//+-----------------------------------+
//----      
int  min_rates_total;
//----   ,    
//      
double ExtHighBuffer[];
double ExtLowBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----     
   min_rates_total=int(BQUALIFY);

//----      
   SetIndexBuffer(0,ExtHighBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----       InpKijun
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtHighBuffer,true);

//----      
   SetIndexBuffer(1,ExtLowBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----       InpKijun
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(ExtLowBuffer,true);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Taf("+string(BQUALIFY)+")");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double;
//----   
   int limit;
   uint VALUE1,VALUE2;
   static uint VALUE1_prev,VALUE2_prev;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      VALUE1_prev=NULL;
      VALUE2_prev=NULL;
     }
   else limit=rates_total-prev_calculated;  //       
   VALUE1=VALUE1_prev;
   VALUE2=VALUE2_prev;
//----         
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtLowBuffer[bar]=0;
      ExtHighBuffer[bar]=0;
      if(High[bar]>=High[bar+1] && Low[bar]>=Low[bar+1])
        {
         if(VALUE2>=BQUALIFY) ExtLowBuffer[bar]=Low[bar+1];
         VALUE1++;
         VALUE2=NULL;
        }
      //----
      if(Low[bar]<=Low[bar+1] && High[bar]<=High[bar+1])
        {
         if(VALUE1>=BQUALIFY) ExtHighBuffer[bar]=High[bar+1];
         VALUE2++;
         VALUE1=NULL;
        }
      if(bar)
        {
         VALUE1_prev=VALUE1;
         VALUE2_prev=VALUE2;
        }
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
