//+------------------------------------------------------------------+
//|                                               Test_ADOnArray.mq5 |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 5
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
// Indicator period: positive value or 0 - all bars.
input int      ADPeriod=0;
//--- indicator buffers
double         ADBuffer[];
//--- 
double         DataHigh[];
double         DataLow[];
double         DataClose[];
double         DataVolume[];

#include <IncOnArray/IncADOnArray.mqh>
CADOnArray ad;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   ad.Init(ADPeriod);

//--- indicator buffers mapping
   SetIndexBuffer(0,ADBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,DataLow,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,DataClose,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,DataVolume,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,ad.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,ad.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
      DataClose[i]=close[i];
      DataVolume[i]=(double)tick_volume[i];
     }

   ad.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,DataVolume,ADBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
