//+------------------------------------------------------------------+
//|                                              Test_ATROnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 5
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int            ATRPeriod  =  14;
input ENUM_MA_METHOD ATRMethod  =  MODE_SMA;
//--- indicator buffers
double         ATRBuffer[];
double         TRBuffer[];
double         DataClose[];
double         DataHigh[];
double         DataLow[];
//---
#include <IncOnArray/IncATROnArray.mqh>
CATROnArray atr;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   atr.Init(ATRPeriod,ATRMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,ATRBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,TRBuffer,INDICATOR_CALCULATIONS);

   SetIndexBuffer(2,DataClose,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,DataLow,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,atr.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,atr.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {

   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataClose[i]=close[i];
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
     }

   atr.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,TRBuffer,ATRBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
