//+------------------------------------------------------------------+
//|                                         Test_DeMarkerOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_maximum 1
#property indicator_minimum 0
#property indicator_buffers 7
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int               DemPeriod   =  14;
input ENUM_MA_METHOD    DemMethod   =  MODE_SMA;
//--- indicator buffers
double         DemBuffer[];
double         PBuffer[];
double         MBuffer[];
double         PSBuffer[];
double         MSBuffer[];
double         DataHigh[];
double         DataLow[];

#include <IncOnArray/IncDemarkerOnArray.mqh>
CDeMarkerOnArray dem;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   dem.Init(DemPeriod,DemMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,DemBuffer,INDICATOR_DATA);

   SetIndexBuffer(1,PBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,MBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,PSBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,MSBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(6,DataLow,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,dem.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,dem.Name());

//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
     }

   dem.Solve(rates_total,prev_calculated,DataHigh,DataLow,PBuffer,MBuffer,PSBuffer,MSBuffer,DemBuffer);

//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
