//+------------------------------------------------------------------+
//|                                             Text_MACDOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 5
#property indicator_plots   2
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_HISTOGRAM
#property indicator_color1  clrAquamarine
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot Label2
#property indicator_label2  "Label2"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrRed
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//--- input parameters
input int             MACDFastPeriod   = 12;
input int             MACDSlowPeriod   = 26;
input int             MACDSignalPeriod = 9;
input ENUM_MA_METHOD  MACDFastMetod    = MODE_EMA;
input ENUM_MA_METHOD  MACDSlowMethod   = MODE_EMA;
input ENUM_MA_METHOD  MACDSignalMethod = MODE_SMA;
//--- indicator buffers
double         MainBuffer[];
double         SignalBuffer[];
double         FMABuffer[];
double         SMABuffer[];
double         data[];
//---
#include <IncOnArray/IncMACDOnArray.mqh>
CMACDOnArray macd;
//---
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   macd.Init(MACDFastPeriod,MACDSlowPeriod,MACDSignalPeriod,MACDFastMetod,MACDSlowMethod,MACDSignalMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,MainBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,SignalBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,FMABuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,SMABuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,data,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,macd.BarsRequiredMain());
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,macd.BarsRequiredSignal());

   PlotIndexSetString(0,PLOT_LABEL,macd.NameMain());
   PlotIndexSetString(1,PLOT_LABEL,macd.NameSignal());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      data[i]=price[i];
     }

   macd.Solve(rates_total,prev_calculated,data,FMABuffer,SMABuffer,MainBuffer,SignalBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
