//+------------------------------------------------------------------+
//|                                              Test_MFIOnArray.mq5 |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
//---
#property indicator_separate_window
#property indicator_buffers 7
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int               MFIPeriod=14;
input ENUM_MA_METHOD    MFIMethod=MODE_SMA;
//--- indicator buffers
double         MFIBuffer[];
double         DataPrice[];
double         DataVolume[];
double         MBuffer[];
double         MSBuffer[];
double         PBuffer[];
double         PSBuffer[];
#include <IncOnArray/IncMFIOnArray.mqh>
CMFIOnArray mfi;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   mfi.Init(MFIPeriod,MFIMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,MFIBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,DataPrice,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,DataVolume,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,MBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,MSBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,PBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(6,PSBuffer,INDICATOR_CALCULATIONS);
//---   
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,mfi.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,mfi.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataPrice[i]=(high[i]+low[i]+close[i])/3;
      DataVolume[i]=(double)tick_volume[i];
     }

   mfi.Solve(rates_total,prev_calculated,DataPrice,DataVolume,PBuffer,MBuffer,PSBuffer,MSBuffer,MFIBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
