//+------------------------------------------------------------------+
//|                                              Test_OBVOnArray.mq5 |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int OBVPeriod=0;
//--- indicator buffers

double         OBVBuffer[];
double         DataClose[];
double         DataVolume[];

#include <IncOnArray/IncOBVOnArray.mqh>
COBVOnArray obv;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   obv.Init(OBVPeriod);

//--- indicator buffers mapping
   SetIndexBuffer(0,OBVBuffer,INDICATOR_DATA);

   SetIndexBuffer(1,DataClose,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,DataVolume,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,obv.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,obv.Name());

//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataClose[i]=close[i];
      DataVolume[i]=(double)tick_volume[i];
     }

   obv.Solve(rates_total,prev_calculated,DataClose,DataVolume,OBVBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
