//+------------------------------------------------------------------+
//|                                              Test_RVIOnArray.mq5 |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 10
#property indicator_plots   2
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot Label2
#property indicator_label2  "Label2"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrYellow
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//--- input parameters
input int            RVIPeriod   =  10;
input ENUM_MA_METHOD RVIMethod   =  MODE_SMA;
//--- indicator buffers
double RVIMBuffer[];
double RVISBuffer[];
double MBuffer[];
double MSBuffer[];
double RBuffer[];
double RSBuffer[];

double DataOpen[];
double DataHigh[];
double DataLow[];
double DataClose[];

#include <IncOnArray/IncRVIOnArray.mqh>
CRVIOnArray rvi;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   rvi.Init(RVIPeriod,RVIMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,RVIMBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,RVISBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,MBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,MSBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,RBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,RSBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(6,DataOpen,INDICATOR_CALCULATIONS);
   SetIndexBuffer(7,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(8,DataLow,INDICATOR_CALCULATIONS);
   SetIndexBuffer(9,DataClose,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,rvi.BarsRequiredMain());
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,rvi.BarsRequiredSignal());
   PlotIndexSetString(0,PLOT_LABEL,rvi.Name()+" Main");
   PlotIndexSetString(1,PLOT_LABEL,rvi.Name()+" Signal");

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
      DataClose[i]=close[i];
      DataOpen[i]=open[i];
     }

   rvi.Solve(rates_total,prev_calculated,DataOpen,DataHigh,DataLow,DataClose,MBuffer,MSBuffer,RBuffer,RSBuffer,RVIMBuffer,RVISBuffer);

//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
