//+---------------------------------------------------------------------+
//|                                                Stochastic_Chart.mq5 | 
//|                                Copyright  2015, Yuriy Tokman (YTG) |
//|                                                  http://ytg.com.ua/ |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2015, Yuriy Tokman (YTG)"
#property link      "http://ytg.com.ua/"
#property description " Stochastic   "
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    5
#property indicator_buffers 5 
//----     
#property indicator_plots   4
//+-------------------------------------------------+
//|   Stochastic Cloud  |
//+-------------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
//----      
#property indicator_color1  clrLavender
//----   
#property indicator_label1  "Stochastic Cloud"
//+-------------------------------------------------+
//|     XMA             |
//+-------------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        MediumBlue
#property indicator_color2  clrMediumBlue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  2
#property indicator_width2  2
//----   
#property indicator_label2  "XMA"
//+-------------------------------------------------+
//|     Stochastic      |
//+-------------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        Crimson
#property indicator_color3  clrCrimson
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  2
#property indicator_width3  2
//----   
#property indicator_label3  "Stochastic"
//+-------------------------------------------------+
//|     Signal          |
//+-------------------------------------------------+
//----   4   
#property indicator_type4   DRAW_LINE
//----        Crimson
#property indicator_color4  clrCrimson
//----   4 -  
#property indicator_style4  STYLE_SOLID
//----    4  2
#property indicator_width4  2
//----   
#property indicator_label4  "Signal"
//+-------------------------------------------------+
//|                               |
//+-------------------------------------------------+
#define RESET 0                //        
//+-------------------------------------------------+
//|    CXMA                           |
//+-------------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-------------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+-------------------------------------------------+
//|                           |
//+-------------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-------------------------------------------------+
//|                           |
//+-------------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-------------------------------------------------+
//|                       |
//+-------------------------------------------------+
input uint KPeriod=5;
input uint DPeriod=3;
input uint Slowing=3;
input ENUM_MA_METHOD STO_Method=MODE_SMA;
input ENUM_STO_PRICE Price_field=STO_LOWHIGH;
input Smooth_Method XMA_Method=MODE_SMMA;             //  
input uint XLength=12;                                //   
input int XPhase=15;                                  //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input double Dev=10.0;                                //   
input ENUM_APPLIED_PRICE  Applied_price=PRICE_CLOSE;  //    handle
input int  Level_Stochastic_UP = 70;                  //  
input int  Level_Stochastic_DN = 30;                  //  
input int Shift=0;                                    //        
//+-------------------------------------------------+
//----   ,   
//----      
double Line1Buffer[];
double Line2Buffer[];
double Line3Buffer[];
double Line4Buffer[];
double Line5Buffer[];
//----
double dLevel_Stochastic_UP,dLevel_Stochastic_DN;
//----      
int min_rates_total,min_rates_1;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_1=int(KPeriod+DPeriod+Slowing);
   min_rates_total=min_rates_1+GetStartBars(XMA_Method,XLength,XPhase);
//----
   dLevel_Stochastic_UP=int(Level_Stochastic_UP-50)*_Point*Dev;
   dLevel_Stochastic_DN=int(Level_Stochastic_DN-50)*_Point*Dev;
//---    Stochastic
   Ind_Handle=iStochastic(Symbol(),NULL,KPeriod,DPeriod,Slowing,STO_Method,Price_field);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("     Stochastic");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,Line1Buffer,INDICATOR_DATA);
//----      
   SetIndexBuffer(1,Line2Buffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);

//----      
   SetIndexBuffer(2,Line3Buffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);

//----      
   SetIndexBuffer(3,Line4Buffer,INDICATOR_DATA);
//----    3    Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       3  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);

//----      
   SetIndexBuffer(4,Line5Buffer,INDICATOR_DATA);
//----    3    Shift
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----       4  min_rates_total
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);

//----       
   ArraySetAsSeries(Line1Buffer,true);
   ArraySetAsSeries(Line2Buffer,true);
   ArraySetAsSeries(Line3Buffer,true);
   ArraySetAsSeries(Line4Buffer,true);
   ArraySetAsSeries(Line5Buffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"Stochastic_Chart(",KPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(Ind_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----       
   double price,xma,Stochastic[],Signal[];
//----        
   int to_copy,limit,bar,maxbar=rates_total-1-min_rates_1;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=maxbar; //      
     }
   else limit=rates_total-prev_calculated; //      
//----
   to_copy=limit+1;
//----      
   if(CopyBuffer(Ind_Handle,MAIN_LINE,0,to_copy,Stochastic)<=0) return(RESET);
   if(CopyBuffer(Ind_Handle,SIGNAL_LINE,0,to_copy,Signal)<=0) return(RESET);
//----       
   ArraySetAsSeries(Stochastic,true);
   ArraySetAsSeries(Signal,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      price=PriceSeries(Applied_price,bar,open,low,high,close);
      xma=XMA1.XMASeries(maxbar,prev_calculated,rates_total,XMA_Method,XPhase,XLength,price,bar,true);
      Line3Buffer[bar]=xma;
      Line4Buffer[bar]=xma+Dev*(Stochastic[bar]-50)*_Point;
      Line5Buffer[bar]=xma+Dev*(Signal[bar]-50)*_Point;
      Line1Buffer[bar]=xma+dLevel_Stochastic_UP;
      Line2Buffer[bar]=xma+dLevel_Stochastic_DN;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
