//+------------------------------------------------------------------+
//|                                                 StodivCandle.mq5 |
//|                                          Copyright  2006, RickD | 
//|                                                http://e2e-fx.net | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, RickD"
#property link "http://e2e-fx.net"
#property description "     "
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----        
#property indicator_buffers 5
//----     
#property indicator_plots   1
//----      
#property indicator_type1   DRAW_COLOR_CANDLES
#property indicator_color1   clrMagenta,clrPurple,clrGray,clrTeal,clrLime
//----   
#property indicator_label1  "StodivCandle Open;StodivCandle High;StodivCandle Low;StodivCandle Close"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int KPeriod=5;
input int DPeriod=3;
input int Slowing=3;
input ENUM_MA_METHOD MA_Method=MODE_SMA;
input ENUM_STO_PRICE Price_field=STO_LOWHIGH;
input uint HighLevel=60;                       //  
input uint LowLevel=40;                        //  
input int Shift=0;                             //      
//+----------------------------------------------+
//----   ,    
//      
double ExtOpenBuffer[];
double ExtHighBuffer[];
double ExtLowBuffer[];
double ExtCloseBuffer[];
double ExtColorBuffer[];

//----      
int min_rates_total;
//----      
int Stochastic_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//----     
   min_rates_total=int(KPeriod+DPeriod+Slowing);
//----    iStochastic
   Stochastic_Handle=iStochastic(NULL,0,KPeriod,DPeriod,Slowing,MA_Method,Price_field);
   if(Stochastic_Handle==INVALID_HANDLE)
     {
      Print("      iStochastic");
      return(INIT_FAILED);
     }  

//----      
   SetIndexBuffer(0,ExtOpenBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtHighBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLowBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,ExtCloseBuffer,INDICATOR_DATA);

//----     ,     
   SetIndexBuffer(4,ExtColorBuffer,INDICATOR_COLOR_INDEX);

//----       
   ArraySetAsSeries(ExtOpenBuffer,true);
   ArraySetAsSeries(ExtHighBuffer,true);
   ArraySetAsSeries(ExtLowBuffer,true);
   ArraySetAsSeries(ExtCloseBuffer,true);
   ArraySetAsSeries(ExtColorBuffer,true);

//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="StodivCandle";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(Stochastic_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----   
   int to_copy,limit,bar,clr;
   double Sto[],Sign[];
   
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      

   to_copy=limit+1;

//----      
   if(CopyBuffer(Stochastic_Handle,MAIN_LINE,0,to_copy,Sto)<=0) return(RESET);
   if(CopyBuffer(Stochastic_Handle,SIGNAL_LINE,0,to_copy,Sign)<=0) return(RESET);
   if(CopyOpen(Symbol(),PERIOD_CURRENT,0,to_copy,ExtOpenBuffer)<=0) return(RESET);
   if(CopyHigh(Symbol(),PERIOD_CURRENT,0,to_copy,ExtHighBuffer)<=0) return(RESET);
   if(CopyLow(Symbol(),PERIOD_CURRENT,0,to_copy,ExtLowBuffer)<=0) return(RESET);
   if(CopyClose(Symbol(),PERIOD_CURRENT,0,to_copy,ExtCloseBuffer)<=0) return(RESET);

//----         
   ArraySetAsSeries(Sto,true);
   ArraySetAsSeries(Sign,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      clr=2;
      if(Sto[bar]>HighLevel) clr=4;
      else if(Sto[bar]<LowLevel) clr=0;
      else if(Sto[bar]>Sign[bar]) clr=3;
      else if(Sto[bar]<Sign[bar]) clr=1;
      ExtColorBuffer[bar]=clr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
