//+------------------------------------------------------------------+
//|                                              Super_TrendSign.mq5 |
//|                   Copyright  2005, Jason Robinson (jnrtrading). | 
//|                                      http://www.jnrtrading.co.uk | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2005, Jason Robinson (jnrtrading)." 
#property link      "http://www.jnrtrading.co.uk" 
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        DarkOrange 
#property indicator_color1  clrDarkOrange
//---    1  2
#property indicator_width1  2
//---    
#property indicator_label1  "Sell Super_Trend signal"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        MediumTurquoise 
#property indicator_color2  clrMediumTurquoise
//---    2  2
#property indicator_width2  2
//---    
#property indicator_label2 "Buy Super_Trend signal"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                             //        
#define UP_DOWN_SHIFT_CR  0
#define UP_DOWN_SHIFT_M1  3
#define UP_DOWN_SHIFT_M2  3
#define UP_DOWN_SHIFT_M3  4
#define UP_DOWN_SHIFT_M4  5
#define UP_DOWN_SHIFT_M5  5
#define UP_DOWN_SHIFT_M6  5
#define UP_DOWN_SHIFT_M10 6
#define UP_DOWN_SHIFT_M12 6
#define UP_DOWN_SHIFT_M15 7
#define UP_DOWN_SHIFT_M20 8
#define UP_DOWN_SHIFT_M30 9
#define UP_DOWN_SHIFT_H1  20
#define UP_DOWN_SHIFT_H2  27
#define UP_DOWN_SHIFT_H3  30
#define UP_DOWN_SHIFT_H4  35
#define UP_DOWN_SHIFT_H6  33
#define UP_DOWN_SHIFT_H8  35
#define UP_DOWN_SHIFT_H12 37
#define UP_DOWN_SHIFT_D1  40
#define UP_DOWN_SHIFT_W1  100
#define UP_DOWN_SHIFT_MN1 120
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int CCIPeriod=14; //   CCI 
input int Level=0;      //   CCI
input int Shift=0;      //       
//+----------------------------------------------+
//---   ,   
//---      
double SellBuffer[],BuyBuffer[];
//----
double UpDownShift;
//----      
int min_rates_total;
//----      
int CCI_Handle,ATR_Handle;
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
int GetUpDownShift(ENUM_TIMEFRAMES Timeframe)
  {
//----
   switch(Timeframe)
     {
      case PERIOD_M1:     return(UP_DOWN_SHIFT_M1);
      case PERIOD_M2:     return(UP_DOWN_SHIFT_M2);
      case PERIOD_M3:     return(UP_DOWN_SHIFT_M3);
      case PERIOD_M4:     return(UP_DOWN_SHIFT_M4);
      case PERIOD_M5:     return(UP_DOWN_SHIFT_M5);
      case PERIOD_M6:     return(UP_DOWN_SHIFT_M6);
      case PERIOD_M10:    return(UP_DOWN_SHIFT_M10);
      case PERIOD_M12:    return(UP_DOWN_SHIFT_M12);
      case PERIOD_M15:    return(UP_DOWN_SHIFT_M15);
      case PERIOD_M20:    return(UP_DOWN_SHIFT_M20);
      case PERIOD_M30:    return(UP_DOWN_SHIFT_M30);
      case PERIOD_H1:     return(UP_DOWN_SHIFT_H1);
      case PERIOD_H2:     return(UP_DOWN_SHIFT_H2);
      case PERIOD_H3:     return(UP_DOWN_SHIFT_H3);
      case PERIOD_H4:     return(UP_DOWN_SHIFT_H4);
      case PERIOD_H6:     return(UP_DOWN_SHIFT_H6);
      case PERIOD_H8:     return(UP_DOWN_SHIFT_H8);
      case PERIOD_H12:    return(UP_DOWN_SHIFT_H12);
      case PERIOD_D1:     return(UP_DOWN_SHIFT_D1);
      case PERIOD_W1:     return(UP_DOWN_SHIFT_W1);
      case PERIOD_MN1:    return(UP_DOWN_SHIFT_MN1);
     }
//----
   return(UP_DOWN_SHIFT_CR);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---    ATR
   int ATR_Period=15;
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----    CCI
   CCI_Handle=iCCI(NULL,0,CCIPeriod,PRICE_TYPICAL);
   if(CCI_Handle==INVALID_HANDLE)
     {
      Print("      CCI");
      return(INIT_FAILED);
     }
//----     
   min_rates_total=int(CCIPeriod)+1;
   min_rates_total=int(MathMax(min_rates_total,ATR_Period));
//----          
   UpDownShift=GetUpDownShift(Period())*_Point;
//----      
   string shortname;
   StringConcatenate(shortname,"Super_Trend(",string(CCIPeriod),", ",string(Shift),")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---   
//PlotIndexSetInteger(0,PLOT_ARROW,234);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----       Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---   
//PlotIndexSetInteger(1,PLOT_ARROW,233);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //       
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || BarsCalculated(CCI_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//----    
   double CCI[],ATR[],cciTrendNow,cciTrendPrevious,TrendUp,TrendDown;
   static double TrendUp_prev,TrendDown_prev;
   int limit,to_copy,bar;
//----    ,     
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(CCI,true);
   ArraySetAsSeries(ATR,true);
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-min_rates_total;                 //      
     }
   else
     {
      limit=rates_total-prev_calculated;                 //      
     }
//----
   to_copy=limit+1;
//----       ATR[]
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
   to_copy++;
//----       CCI[]
   if(CopyBuffer(CCI_Handle,0,0,to_copy,CCI)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      cciTrendNow=CCI[bar]+70;
      cciTrendPrevious=CCI[bar+1]+70;
      //----
      if(cciTrendNow>=Level && cciTrendPrevious<Level) TrendUp_prev=TrendDown_prev;
      if(cciTrendNow<=Level && cciTrendPrevious>Level) TrendDown_prev=TrendUp_prev;
      //----
      if(cciTrendNow>Level)
        {
         TrendDown=0.0;
         TrendUp=low[bar]-UpDownShift;
         if(close[bar]<open[bar] && TrendDown_prev!=TrendUp_prev) TrendUp=TrendUp_prev;
         if(TrendUp<TrendUp_prev && TrendDown_prev!=TrendUp_prev) TrendUp=TrendUp_prev;
         if(high[bar]<high[bar+1]&& TrendDown_prev!=TrendUp_prev) TrendUp=TrendUp_prev;
        }
      //----
      if(cciTrendNow<Level)
        {
         TrendUp=0.0;
         TrendDown=high[bar]+UpDownShift;
         if(close[bar]>open[bar] && TrendUp_prev!=TrendDown_prev) TrendDown_prev=TrendDown_prev;
         if(TrendDown>TrendDown_prev && TrendDown_prev!=TrendUp_prev) TrendDown=TrendDown_prev;
         if(low[bar]>low[bar+1] && TrendUp_prev!=TrendDown_prev) TrendDown=TrendDown_prev;
        }
      //----
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      if(TrendDown_prev && TrendUp) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(TrendUp_prev && TrendDown) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
      //----
      if(bar)
        {
         TrendUp_prev=TrendUp;
         TrendDown_prev=TrendDown;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
