//+------------------------------------------------------------------+
//|                                                    SVS_Trend.mq5 | 
//|                                            Copyright  2009, SVS | 
//+------------------------------------------------------------------+
//| For the indicator to work, place the SmoothAlgorithms.mqh file   |
//| to the terminal_data_folder\MQL5\Include                         |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, SVS"
#property link ""
#property description "SVS_Trend"
//---- indicator version number
#property version   "1.00"
//---- drawing indicator in a separate window
#property indicator_separate_window
//---- number of indicator buffers
#property indicator_buffers 6 
//---- 6 graphical plots are used in total
#property indicator_plots   6
//+--------------------------------------------+
//|  Parameters of indicator drawing           |
//+--------------------------------------------+
//---- drawing the indicators as histograms
#property indicator_type1   DRAW_HISTOGRAM
#property indicator_type2   DRAW_HISTOGRAM
#property indicator_type3   DRAW_HISTOGRAM
#property indicator_type4   DRAW_HISTOGRAM
#property indicator_type5   DRAW_HISTOGRAM
#property indicator_type6   DRAW_HISTOGRAM
//---- selection of histogram colors
#property indicator_color1 LightSteelBlue
#property indicator_color2 BlueViolet
#property indicator_color3 Black
#property indicator_color4 MediumBlue
#property indicator_color5 Red
#property indicator_color6 Lime
//---- the width of histogram bars is 3
#property indicator_width1  3
#property indicator_width2  3
#property indicator_width3  3
#property indicator_width4  3
#property indicator_width5  3
#property indicator_width6  3
//+-----------------------------------+
//|  Description of smoothing classes |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//---- declaration of the CXMA classes variables from the SmoothAlgorithms.mqh file
CXMA XMA1,XMA2;
//+-----------------------------------+
//|  Declaration of enumerations      |
//+-----------------------------------+
enum Applied_price_      // type of constant
  {
   PRICE_CLOSE_ = 1,     // Close
   PRICE_OPEN_,          // Open
   PRICE_HIGH_,          // High
   PRICE_LOW_,           // Low
   PRICE_MEDIAN_,        // Median Price (HL/2)
   PRICE_TYPICAL_,       // Typical Price (HLC/3)
   PRICE_WEIGHTED_,      // Weighted Close (HLCC/4)
   PRICE_SIMPLE,         // Simple Price (OC/2)
   PRICE_QUARTER_,       // Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  // TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_   // TrendFollow_2 Price 
  };
/*enum Smooth_Method - the enumeration is declared in the SmoothAlgorithms.mqh file
  {
   MODE_SMA_,  // SMA
   MODE_EMA_,  // EMA
   MODE_SMMA_, // SMMA
   MODE_LWMA_, // LWMA
   MODE_JJMA,  // JJMA
   MODE_JurX,  // JurX
   MODE_ParMA, // ParMA
   MODE_T3,    // T3
   MODE_VIDYA, // VIDYA
   MODE_AMA,   // AMA
  }; */
//+-----------------------------------+
//|  Indicator input parameters       |
//+-----------------------------------+
input Smooth_Method MA_Method1=MODE_SMA; // First smoothing method
input int Length1=100;                   // First smoothing depth                    
input int Phase1=15;                     // First smoothing parameter
input Applied_price_ IPC=PRICE_QUARTER_; // Price constant
input int Shift=0;                       // Horizontal shift of the indicator
//+-----------------------------------+
//---- declaration of dynamic arrays that
//---- will be used as indicator buffers
double ExtMapBuffer1[],ExtMapBuffer2[],ExtMapBuffer3[];
double ExtMapBuffer4[],ExtMapBuffer5[],ExtMapBuffer6[];
//---- declaration of integer variables for the start of data calculation
int min_rates_total,StartBars1;
//+------------------------------------------------------------------+   
//| SVS_Trend indicator initialization function                      | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---- initialization of variables of the start of data calculation
   StartBars1=XMA1.GetStartBars(MA_Method1,Length1,Phase1)+1;
   min_rates_total=StartBars1+XMA1.GetStartBars(MA_Method1,Length1,Phase1);

//---- setting up alerts for unacceptable values of external parameters
   XMA1.XMALengthCheck("Length1",Length1);
//---- setting up alerts for unacceptable values of external parameters
   XMA1.XMAPhaseCheck("Phase1",Phase1,MA_Method1);

//---- converting dynamic arrays into indicator buffers
   SetIndexBuffer(0,ExtMapBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtMapBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,ExtMapBuffer3,INDICATOR_DATA);
   SetIndexBuffer(3,ExtMapBuffer4,INDICATOR_DATA);
   SetIndexBuffer(4,ExtMapBuffer5,INDICATOR_DATA);
   SetIndexBuffer(5,ExtMapBuffer6,INDICATOR_DATA);

//---- set the position, from which the indicator drawing starts
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(5,PLOT_DRAW_BEGIN,min_rates_total);

//---- restriction to draw empty values for the indicator
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(5,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//---- initializations of variable for a short name of the indicator
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   StringConcatenate(shortname,"SVS_Trend(",Length1,", ",Phase1,", ",
                     EnumToString(IPC),", ",Shift,", ",Smooth1,")");
//--- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//--- determination of accuracy of displaying the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---- initialization end
  }
//+------------------------------------------------------------------+ 
//| SVS_Trend iteration function                                     | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    // number of bars in history at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---- checking the number of bars to be enough for the calculation
   if(rates_total<min_rates_total) return(0);

//---- declaration of variables with a floating point  
   double z,s1,v1,vv,sv,svz,vj,vk,vd,ff;
//---- declaration of integer variables and getting already calculated bars
   int first,bar;

//---- calculation of the 'first' starting number for the bars recalculation loop
   if(prev_calculated>rates_total || prev_calculated<=0) // checking for the first start of the indicator calculation
      first=0;                   // starting index for calculation of all bars
   else first=prev_calculated-1; // starting index for calculation of new bars

//---- main loop of the indicator calculation
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      z=PriceSeries(IPC,bar,open,low,high,close)/_Point;
      s1=XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,z,bar,false);
      v1=XMA2.XMASeries(StartBars1,prev_calculated,rates_total,MA_Method1,Phase1,Length1,s1,bar,false);
      //---------------------------------               
      sv=(s1+v1)/2;
      svz=(sv+z)/2;
      ff=(svz-sv);
      vv=(s1-v1);
      vk=(vv+ff)/2;
      vd=(ff/2);
      vj=(vv-vd);
      //----------------------------
      ExtMapBuffer1[bar]=vv;
      ExtMapBuffer2[bar]=vk;
      ExtMapBuffer3[bar]=vd;
      ExtMapBuffer4[bar]=EMPTY_VALUE;
      ExtMapBuffer5[bar]=EMPTY_VALUE;
      ExtMapBuffer6[bar]=EMPTY_VALUE;

      if(vd>0) ExtMapBuffer4[bar]=vj;
      if(vd<0) ExtMapBuffer5[bar]=vj;

      if(vd>0 && vk<vj) ExtMapBuffer6[bar]=vj;
      if(vd<0 && vk>vj) ExtMapBuffer6[bar]=vj;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
