//+------------------------------------------------------------------+ 
//|                                      RangeExpansionIndex_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//---   
#property version   "1.60"
//---     
#property indicator_separate_window 
//---    2
#property indicator_buffers 2 
//---     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//---       
#property indicator_color1 clrGray,clrLime,clrBlue,clrRed,clrMagenta
//---   - 
#property indicator_style1 STYLE_SOLID
//---     5
#property indicator_width1 5
//---   
#property indicator_label1 "RangeExpansionIndex HTF"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 +60
#property indicator_level2 -60
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                     |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //  
input uint REI_Period=8;                   //  
input bool ReDraw=true;                    //      
//+----------------------------------------------+
//---      
int min_rates_total;
//---      
int Ind_Handle;
//---   ,  
//---       
double IndBuffer[],ColorBuffer[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {
//---
   return(StringSubstr(EnumToString(timeframe),7,-1));
//---
  }
//+------------------------------------------------------------------+    
//| REI indicator initialization function                            | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=3;
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    REI       ");
      return(INIT_FAILED);
     }
//---    RangeExpansionIndex
   Ind_Handle=iCustom(Symbol(),TimeFrame,"RangeExpansionIndex",REI_Period);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      REI");
      return(INIT_FAILED);
     }
//---    IndBuffer   
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---       
   ArraySetAsSeries(IndBuffer,true);
//---     ,     
   SetIndexBuffer(1,ColorBuffer,INDICATOR_COLOR_INDEX);
//---       
   ArraySetAsSeries(ColorBuffer,true);
//---      
   string shortname;
   StringConcatenate(shortname,"REI HTF( ",GetStringTimeframe(TimeFrame),", ",REI_Period," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| REI iteration function                                           | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---   
   int limit,bar;
//---       
   double REI[2];
   datetime REITime[1];
   static uint LastCountBar;
//---      
//---   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       
//---         
   ArraySetAsSeries(time,true);
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuffer[bar]=EMPTY_VALUE;
      ColorBuffer[bar]=0;
      //---      
      if(CopyTime(Symbol(),TimeFrame,time[bar],1,REITime)<=0) return(RESET);

      if(time[bar]>=REITime[0] && time[bar+1]<REITime[0])
        {
         LastCountBar=bar;
         //---      
         if(CopyBuffer(Ind_Handle,0,time[bar],2,REI)<=0) return(RESET);
         //---      
         IndBuffer[bar]=REI[1];
         //--- 
         if(IndBuffer[bar]>50)
           {
            if(REI[1]>REI[0]) ColorBuffer[bar]=1;
            if(REI[1]<REI[0]) ColorBuffer[bar]=2;
           }
         //---
         if(IndBuffer[bar]<50)
           {
            if(REI[1]<REI[0]) ColorBuffer[bar]=3;
            if(REI[1]>REI[0]) ColorBuffer[bar]=4;
           }
        }
      //---
      if(ReDraw)
        {
         if(IndBuffer[bar+1]!=EMPTY_VALUE && IndBuffer[bar]==EMPTY_VALUE)
           {
            IndBuffer[bar]=IndBuffer[bar+1];
            ColorBuffer[bar]=ColorBuffer[bar+1];
           }
        }
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
