//+---------------------------------------------------------------------+ 
//|                                                       M2_MA_HTF.mq5 | 
//|                                  Copyright  2016, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\MQL5\Include         |
//+---------------------------------------------------------------------+ 
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.60"
//----     
#property indicator_chart_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                //        
#define INDICATOR_NAME "M2_MA" //    
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_COLOR_ARROW
//----     
#property indicator_color1  clrGray,clrMagenta,clrBlue
//----    1  4
#property indicator_width1  4
//----    
#property indicator_label1  INDICATOR_NAME
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_, //PRICE_TRENDFOLLOW0_
   PRICE_TRENDFOLLOW1_  //PRICE_TRENDFOLLOW1_
  };
//+-------------------------------------+
//|           |
//+-------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;// 
input uint AlertCount=0;//  
input uint SignalBar=1;//   , 0- 
//+-------------------------------------+
//|           |
//+-------------------------------------+
input Smooth_Method XMA_Method=MODE_SMA_; //  
input uint MPeriod=6;                     //   
input int XPhase=15;                      //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA                      
input Applied_price_ IPC=PRICE_CLOSE_;    //  
input int Shift=0;                        //      
input int PriceShift=0;                   // c     
//+-------------------------------------+
//----   ,    
//      
double IndBuffer[],ColorIndBuffer[];
//----  
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int M2_MA_Handle;
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    M2_MA       ");
      return(INIT_FAILED);
     }

//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);

//----    M2_MA
   M2_MA_Handle=iCustom(Symbol_,TimeFrame,"M2_MA",XMA_Method,MPeriod,XPhase,IPC,0,PriceShift);
   if(M2_MA_Handle==INVALID_HANDLE)
    {
     Print("      M2_MA");
     return(INIT_FAILED);
    }

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----       
   ArraySetAsSeries(IndBuffer,true);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,INDICATOR_NAME);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(M2_MA_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);

//----    
   double M2_MA[1];
   int limit,bar;
   datetime M2_MATime[1];
   static uint UpCount,DnCount;
   static uint UpCount_,DnCount_;
   static double LastM2_MA=0.0;
   static uint LastCountBar;

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      LastCountBar=rates_total;
     }
   else limit=int(LastCountBar)+rates_total-prev_calculated; //       

//----         
   ArraySetAsSeries(time,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuffer[bar]=0.0;

      //----       M2_MATime
      if(CopyTime(Symbol_,TimeFrame,time[bar],1,M2_MATime)<=0) return(RESET);
      
      if(time[bar]>=M2_MATime[0] && time[bar+1]<M2_MATime[0])
        {
         LastCountBar=bar;
         
         //----       M2_MA
         if(CopyBuffer(M2_MA_Handle,0,time[bar],1,M2_MA)<=0) return(RESET);
         
         IndBuffer[bar]=M2_MA[0];
        }
     }

//----   
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit--; //      

//----     
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorIndBuffer[bar]=0;

      if(IndBuffer[bar])
        {
         if(LastM2_MA)
           {
            if(LastM2_MA<IndBuffer[bar]) ColorIndBuffer[bar]=2;
            if(LastM2_MA>IndBuffer[bar]) ColorIndBuffer[bar]=1;
           }

         if(bar>0) LastM2_MA=IndBuffer[bar];
        }

     }

//----     
   if(rates_total!=prev_calculated)
     {
      UpCount=0;
      DnCount=0;
      UpCount_=0;
      DnCount_=0;
     }

//----    
   if(UpCount<AlertCount && ColorIndBuffer[SignalBar]==2)
     {
      UpCount++;
      Alert(Word+":     "+Symbol_);
     }

//----    
   if(DnCount<AlertCount && ColorIndBuffer[SignalBar]==1)
     {
      DnCount++;
      Alert(Word+":     "+Symbol_);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
