//+------------------------------------------------------------------+
//|                                                    MACD_DLC4.mq5 |
//|                                          Copyright 2009, Mr.Zhjp |
//|                                            mail://mrzhjp@163.com |
//+------------------------------------------------------------------+
#property copyright   "2009, Mr.Zhjp"
#property link        "mrzhjp@163.com"
#property description "Moving Average Convergence/Divergence"
#include <MovingAverages.mqh>
//--- indicator settings
#property indicator_separate_window
#property indicator_buffers 6
#property indicator_plots   3                         // New
#property indicator_type1   DRAW_LINE
#property indicator_type2   DRAW_LINE
#property indicator_type3   DRAW_COLOR_HISTOGRAM
#property indicator_color1  Aqua
#property indicator_color2  Yellow
#property indicator_color3  White, LimeGreen, DarkGreen, Maroon, Red
#property indicator_width1  0
#property indicator_width2  0
#property indicator_width3  0
#property indicator_label1  "DIFF"
#property indicator_label2  "DEA"
#property indicator_label3  "MACD"
//--- input parameters
input int                InpFastEMA=5;               // Fast EMA period
input int                InpSlowEMA=34;               // Slow EMA period
input int                InpSignalEMA=5;              // Signal EMA period
input ENUM_APPLIED_PRICE InpAppliedPrice=PRICE_CLOSE; // Applied price
//--- indicator buffers
double                   ExtDIFFBuffer[];
double                   ExtDEABuffer[];
double                   ExtMACDBuffer[];
double                   ExtMACDColor[];
double                   ExtFastMaBuffer[];
double                   ExtSlowMaBuffer[];
//--- MA handles
int                      ExtFastMaHandle;
int                      ExtSlowMaHandle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,ExtDIFFBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,ExtDEABuffer,INDICATOR_DATA);
   SetIndexBuffer(2,ExtMACDBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,ExtMACDColor,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(4,ExtFastMaBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,ExtSlowMaBuffer,INDICATOR_CALCULATIONS);
//--- sets first bar from what index will be drawn
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,InpSignalEMA-1);
//--- name for Dindicator subwindow label
   IndicatorSetString(INDICATOR_SHORTNAME,"MACD_DLC4("+string(InpFastEMA)+","+string(InpSlowEMA)+","+string(InpSignalEMA)+")");
//--- get MA handles
   ExtFastMaHandle=iMA(NULL,0,InpFastEMA,0,MODE_EMA,InpAppliedPrice);
   ExtSlowMaHandle=iMA(NULL,0,InpSlowEMA,0,MODE_EMA,InpAppliedPrice);
//--- initialization done
  }
//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence                           |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,const int prev_calculated,
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &TickVolume[],
                const long &Volume[],
                const int &Spread[])
  {
//--- check for data
   if(rates_total<InpSignalEMA)
      return(0);
//--- not all data may be calculated
   int calculated=BarsCalculated(ExtFastMaHandle);
   if(calculated<rates_total)
     {
      Print("Not all data of ExtFastMaHandle is calculated (",calculated,"bars ). Error",GetLastError());
      return(0);
     }
   calculated=BarsCalculated(ExtSlowMaHandle);
   if(calculated<rates_total)
     {
      Print("Not all data of ExtSlowMaHandle is calculated (",calculated,"bars ). Error",GetLastError());
      return(0);
     }
//--- we can copy not all data
   int to_copy;
   if(prev_calculated>rates_total || prev_calculated<0) to_copy=rates_total;
   else
     {
      to_copy=rates_total-prev_calculated;
      if(prev_calculated>0) to_copy++;
     }
//--- get Fast EMA buffer
   if(CopyBuffer(ExtFastMaHandle,0,0,to_copy,ExtFastMaBuffer)<=0)
     {
      Print("Getting fast EMA is failed! Error",GetLastError());
      return(0);
     }
//--- get Slow EMA buffer
   if(CopyBuffer(ExtSlowMaHandle,0,0,to_copy,ExtSlowMaBuffer)<=0)
     {
      Print("Getting slow EMA is failed! Error",GetLastError());
      return(0);
     }
//---
   int limit;
   if(prev_calculated==0)
      limit=0;
   else limit=prev_calculated-1;
//--- calculate DIFF
   for(int i=limit;i<rates_total;i++)
      ExtDIFFBuffer[i]=ExtFastMaBuffer[i]-ExtSlowMaBuffer[i];
//--- calculate DEA
   // SimpleMAOnBuffer(rates_total,prev_calculated,0,InpSignalSMA,ExtDIFFBuffer,ExtDEABuffer);
   ExponentialMAOnBuffer(rates_total,prev_calculated,0,InpSignalEMA,ExtDIFFBuffer,ExtDEABuffer);
//--- calculate MACD
   for(int i=limit;i<rates_total;i++)
   {
      ExtMACDBuffer[i] = 2*(ExtDIFFBuffer[i]-ExtDEABuffer[i]); 
      if(ExtMACDBuffer[i] > 0) 
      {
        if(ExtMACDBuffer[i] > ExtMACDBuffer[i-1])
          ExtMACDColor[i] = 1;
        else
          ExtMACDColor[i] = 2;
      }
      else if(ExtMACDBuffer[i] < 0) 
      {
        if(ExtMACDBuffer[i] < ExtMACDBuffer[i-1])
          ExtMACDColor[i] = 3;
        else
          ExtMACDColor[i] = 4;
      }
      else
        ExtMACDColor[i] = 0;
   }      
//--- OnCalculate done. Return new prev_calculated.
   return(rates_total);
  }
//+------------------------------------------------------------------+
