//+---------------------------------------------------------------------+
//|                                                      Mass_Index.mq5 |
//|                         Copyright  2007, MetaQuotes Software Corp. |
//|                                           http://www.metaquotes.net |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window 
//---   
#property indicator_buffers 1 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---       Teal 
#property indicator_color1 clrTeal
//---   -  
#property indicator_style1  STYLE_SOLID
//---     1
#property indicator_width1  1
//---   
#property indicator_label1  "Mass_Index"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//---    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2,XMA3;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA    //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method MA_Method1=MODE_EMA; //     
input int Length1=9;                     //                       
input int Phase1=15;                     //   
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_EMA; //     
input int Length2=9;                     //    
input int Phase2=15;                     //   
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method3=MODE_SMA; //     
input int Length3=25;                    //    
input int Phase3=15;                     //   
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input int Shift=0;                       //      
//+-----------------------------------+
//---   ,   
//---      
double IndBuffer[];
//---      
int min_rates_total,min_rates_1,min_rates_2;
//+------------------------------------------------------------------+   
//| Mass_Index indicator initialization function                     | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_1=XMA1.GetStartBars(MA_Method1,Length1,Phase1);
   min_rates_2=min_rates_1+XMA2.GetStartBars(MA_Method2,Length2,Phase2);
   min_rates_total=min_rates_2+XMA3.GetStartBars(MA_Method3,Length3,Phase3);
//---       
   XMA1.XMALengthCheck("Length1",Length1);
   XMA2.XMALengthCheck("Length2",Length2);
   XMA3.XMALengthCheck("Length3",Length3);
//---       
   XMA1.XMAPhaseCheck("Phase1",Phase1,MA_Method1);
   XMA2.XMAPhaseCheck("Phase2",Phase2,MA_Method2);
   XMA2.XMAPhaseCheck("Phase3",Phase3,MA_Method3);
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Mass_Index");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
  }
//+------------------------------------------------------------------+ 
//| Mass_Index iteration function                                    | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---       
   double range,xrange,xxrange,ratio;
//---        
   int first,bar;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //---   PriceSeries     price_
      range=high[bar]-low[bar];
      xrange=XMA1.XMASeries(0,prev_calculated,rates_total,MA_Method1,Phase1,Length1,range,bar,false);      
      xxrange=XMA2.XMASeries(min_rates_1,prev_calculated,rates_total,MA_Method2,Phase2,Length2,xrange,bar,false);
      if(xxrange) ratio=xrange/xxrange;
      else ratio=1;
      IndBuffer[bar]=XMA3.XMASeries(min_rates_2,prev_calculated,rates_total,MA_Method3,Phase3,Length3,ratio,bar,false);
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
