//+------------------------------------------------------------------+
//|                                                   MI_Fractal.mq5 |
//|                                    Copyright  2009  .. |
//|                                        http://www.vk.com/mtforex |
//+------------------------------------------------------------------+
#property description "       "
//---  
#property copyright "Copyright  2009  .."
//---    
#property link      "http://www.vk.com/mtforex"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---     
#property indicator_plots   2
//+----------------------------------------------+
//|          |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---      MediumSeaGreen 
#property indicator_color1  clrMediumSeaGreen
//---    1  3
#property indicator_width1  3
//---    
#property indicator_label1  "Up MI_Fractal"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---      Tomato 
#property indicator_color2  clrTomato
//---    2  3
#property indicator_width2  3
//---    
#property indicator_label2 "Down MI_Fractal"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint LeftCount=10; //   
input uint RightCount=2; //   
input uint MinDiff=10;   //        
input int  UpLable=217;  //   
input int  DnLable=218;  //   
//+----------------------------------------------+
//---   ,   
//---      
double UpBuffer[];
double DnBuffer[];
//---
double dMinDiff;
int min_rates_total;
//---      
int ATR_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---    
   dMinDiff=MinDiff*_Point;
   int ATR_Period=10;
   min_rates_total=int(MathMax(ATR_Period,LeftCount+RightCount));
//---    ATR
   ATR_Handle=iATR(Symbol(),PERIOD_CURRENT,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,UpLable);
//---       
   ArraySetAsSeries(UpBuffer,true);
//---      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//---      
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,DnLable);
//---       
   ArraySetAsSeries(DnBuffer,true);
//---      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="MI_Fractal";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int to_copy,limit;
   double ATR[];
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated+2; //      
     }
   to_copy=limit+min_rates_total;
//---      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(ATR,true);
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      bool UP_Fractal=true;
      bool DOWN_Fractal=true;
      //---
      for(int index=bar+int(LeftCount); index>=bar-int(RightCount); index--)
        {
         if(index==bar) continue;
         if(high[bar]-high[index]<dMinDiff) UP_Fractal=false;
         if(low[index]-low[bar]<dMinDiff) DOWN_Fractal=false;
        }
      //---
      UpBuffer[bar]=0.0;
      DnBuffer[bar]=0.0;
      //---
      if(UP_Fractal && !DOWN_Fractal) UpBuffer[bar]=high[bar]+ATR[bar]*3/8;
      if(!UP_Fractal && DOWN_Fractal) DnBuffer[bar]=low[bar]-ATR[bar]*3/8;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
