//+---------------------------------------------------------------------+
//|                                               i-CAi_Cloud_Digit.mq5 | 
//|                         Copyright  RickD 2006, Alexander Piechotta | 
//|                                        http://onix-trade.net/forum/ | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  RickD 2006, Alexander Piechotta"
#property link      "http://onix-trade.net/forum/"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    6
#property indicator_buffers 6 
//----     
#property indicator_plots   3
//+------------------------------------------------+
//|                          |
//+------------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
#property indicator_type2   DRAW_FILLING
//----   
#property indicator_color1  clrPowderBlue
#property indicator_color2  clrPink
//----  
#property indicator_label1  "Upper Cloud"
#property indicator_label2  "Lower Cloud"
//+------------------------------------------------+
//|                    |
//+------------------------------------------------+
//----      
#property indicator_type3   DRAW_COLOR_LINE
//----      
#property indicator_color3  clrDodgerBlue,clrMagenta
//----   -  
#property indicator_style3  STYLE_SOLID
//----     5
#property indicator_width3  5
//----   
#property indicator_label3  "i-CAi_Digit"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA  CStdDeviation   SmoothAlgorithms.mqh
CXMA XMA1;
CStdDeviation STD;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_      // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input string  SirName="i-CAi_Digit";      //    
input Smooth_Method XMA_Method=MODE_SMA_; // 
input uint XLength=12;                    //                     
input int XPhase=15;                      // ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;    // 
input uint Digit=2;                       //  
input uint Dev=20;                        //  
input bool ShowPrice=true;                //  
input color  Price_color=clrDarkViolet;   //  
input int Shift=0;                        //     
//+----------------------------------------------+
//----   ,         
double LineBuffer[],ColorLineBuffer[];
double UpCloudBuffer1[],UpCloudBuffer2[];
double DnCloudBuffer1[],DnCloudBuffer2[];
//----      
double dPriceShift;
//----      
int min_rates_total;
double PointPow10;
//----     
string Price_name;
//+------------------------------------------------------------------+   
//| i-CAi indicator initialization function                          | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=GetStartBars(XMA_Method,XLength,XPhase);
   PointPow10=_Point*MathPow(10,Digit);
//----  
   Price_name=SirName+"Price";

//----         
   SetIndexBuffer(0,UpCloudBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,UpCloudBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,DnCloudBuffer1,INDICATOR_DATA);
   SetIndexBuffer(3,DnCloudBuffer2,INDICATOR_DATA);
   SetIndexBuffer(4,LineBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(5,ColorLineBuffer,INDICATOR_COLOR_INDEX);
   
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"i-CAi_Digit(",XLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,Price_name);
//----
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+ 
//| i-CAi iteration function                                         | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double price,xma,stdev,powstdev,powdxma,koeff,prev;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1; //      
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     price
      price=PriceSeries(IPC,bar,open,low,high,close);
      xma=XMA1.XMASeries(1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,price,bar,false);
      stdev=STD.StdDevSeries(1,prev_calculated,rates_total,XLength,1,price,xma,bar,false);
      powstdev=MathPow(stdev,2);
      if(bar>min_rates_total) prev=LineBuffer[bar-1];
      else prev=xma;
      powdxma=MathPow(prev-xma,2);
      if(powdxma<powstdev || !powdxma) koeff=0.0;
      else koeff=1.0-powstdev/powdxma;
      LineBuffer[bar]=prev+koeff*(xma-prev);
      LineBuffer[bar]=UpCloudBuffer2[bar]=DnCloudBuffer1[bar]=PointPow10*MathRound(LineBuffer[bar]/PointPow10);
      UpCloudBuffer1[bar]=LineBuffer[bar]*Dev;
      DnCloudBuffer2[bar]=LineBuffer[bar]/Dev;
     }
   if(ShowPrice)
     {
      int bar0=rates_total-1;
      datetime time0=time[bar0]+1*PeriodSeconds();
      SetRightPrice(0,Price_name,0,time0,LineBuffer[bar0],Price_color);
     }
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first++;

//----     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      int clr=int(ColorLineBuffer[bar-1]);
      if(LineBuffer[bar-1]<LineBuffer[bar]) clr=0;
      if(LineBuffer[bar-1]>LineBuffer[bar]) clr=1;
      ColorLineBuffer[bar]=clr;
     }
//----
   ChartRedraw(0);
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color              // Text color
                      )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,2);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,// chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color              // Text color
                   )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color);
   else ObjectMove(chart_id,name,0,time,price);
//----
  }
//+------------------------------------------------------------------+
