//+------------------------------------------------------------------+
//|                                                      ind_aMU.mq5 |
//|                             Copyright  2012, Yuriy Tokman (YTG) |
//|                                            yuriytokman@gmail.com |
//+------------------------------------------------------------------+ 
//----  
#property copyright "Copyright  2012, Yuriy Tokman (YTG)"
//----    
#property link      "yuriytokman@gmail.com"
//----   
#property version   "1.00"
#property description "      ()  "
//+----------------------------------------------+ 
//|                  |
//+----------------------------------------------+ 
//----     
#property indicator_chart_window 
//----       2 
#property indicator_buffers 2
//----   1  
#property indicator_plots   1
//----     ZIGZAG
#property indicator_type1   DRAW_ZIGZAG
//----   
#property indicator_label1  "ind_aMU"
//----       - 
#property indicator_color1 clrBlueViolet
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+ 
//|                    |
//+----------------------------------------------+ 
input uint              FastPeriod = 12;
input uint              SlowPeriod = 21;
input  ENUM_MA_METHOD       MAType = MODE_EMA;
input ENUM_APPLIED_PRICE   MAPrice = PRICE_CLOSE;
//+----------------------------------------------+
//----   ,    
//----      
double SlowBuffer[];
double FastBuffer[];
//----      
int min_rates_total;
//----      
int FsMA_Handle,SlMA_Handle;
//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_total=int(MathMax(FastPeriod,SlowPeriod));
//----    Fast iMA
   SlMA_Handle=iMA(Symbol(),PERIOD_CURRENT,FastPeriod,0,MAType,MAPrice);
   if(SlMA_Handle==INVALID_HANDLE)
     {
      Print("      Fast iMA");
      return(INIT_FAILED);
     }
//----    Slow iMA
   FsMA_Handle=iMA(Symbol(),PERIOD_CURRENT,SlowPeriod,0,MAType,MAPrice);
   if(FsMA_Handle==INVALID_HANDLE)
     {
      Print("      Slow iMA");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,FastBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,SlowBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----          
   ArraySetAsSeries(FastBuffer,true);
   ArraySetAsSeries(SlowBuffer,true);
//----  ,     
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string shortname;
   StringConcatenate(shortname,"ind_aMU(",FastPeriod,",",SlowPeriod,")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----  
   return(INIT_SUCCEEDED); 
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(FsMA_Handle)<rates_total
      || BarsCalculated(SlMA_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//----    
   int to_copy;
//----    limit        
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      to_copy=rates_total-min_rates_total+1; //      
     }
   else
     {
      to_copy=rates_total-prev_calculated+1; //      
     }
//----      
   if(CopyBuffer(FsMA_Handle,0,0,to_copy,FastBuffer)<=0) return(RESET);
   if(CopyBuffer(SlMA_Handle,0,0,to_copy,SlowBuffer)<=0) return(RESET);
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
