//+------------------------------------------------------------------+
//|                                                    InstTrend.mq5 |
//|                                                                  |
//|                                                                  |
//| Algorithm taken from book                                        |
//|     "Cybernetics Analysis for Stock and Futures"                 |
//| by John F. Ehlers                                                |
//|                                                                  |
//|                                              contact@mqlsoft.com |
//|                                          http://www.mqlsoft.com/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Coded by Witold Wozniak"
//----  
#property link      "www.mqlsoft.com"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_FILLING
//----    
#property indicator_color1  clrMediumOrchid,clrAqua
//----   
#property indicator_label1  "InstTrend"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double Alpha=0.07;//  
input int Shift=0; //       
//+----------------------------------------------+
//----   ,    
//      
double ITrendBuffer[];
double TriggerBuffer[];
//----      
int min_rates_total;
//----   
double K0,K1,K2,K3,K4;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=8+3;
   
//----  
  double A2=Alpha*Alpha;
  K0=Alpha-A2/4.0;
  K1=0.5*A2;
  K2=Alpha-0.75*A2;
  K3=2.0 *(1.0 - Alpha);
  K4=MathPow((1.0 - Alpha),2);
    
//----      
   SetIndexBuffer(0,ITrendBuffer,INDICATOR_DATA);
//----      
   SetIndexBuffer(1,TriggerBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  30
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,30);

//----      
   string shortname;
   StringConcatenate(shortname,"Instantaneous Trendline(",Alpha,", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----    
   int first,bar;
   double price0,price1,price2;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=3; //      
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price0=(high[bar]+low[bar])/2.0;
      price1=(high[bar-1]+low[bar-1])/2.0;
      price2=(high[bar-2]+low[bar-2])/2.0;

      if(bar<min_rates_total) ITrendBuffer[bar] = (price0+2.0*price1+price2)/4.0;
      else ITrendBuffer[bar] = K0*price0 + K1*price1 - K2*price2 + K3*ITrendBuffer[bar-1] - K4*ITrendBuffer[bar-2];

      TriggerBuffer[bar]=2.0*ITrendBuffer[bar]-ITrendBuffer[bar-2];
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
