//+------------------------------------------------------------------+
//|                                              InverseReaction.mq5 |
//|                                        Copyright 2013, Erdem Sen |
//|                         http://login.mql5.com/en/users/erdogenes |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, Erdem Sen"
#property version   "1.1"
#property link      "http://login.mql5.com/en/users/erdogenes"
//---
#property description "This indicator is based on the idea of that an unusual impact in price changes will be" 
#property description "adjusted by an inverse reaction. It consists of two main buffers: One shows gap-free"
#property description "price changes and the other(s) shows the possible volatility limits."
#property description "The signal comes out when the price change buffer exceeds the possible volatility limits."
#property description "Then you can expect an inverse reaction."

//--- Indicator
#property indicator_separate_window
#property indicator_buffers 5
#property indicator_plots   3

//--- PriceChanges Plot
#property indicator_label1  "PriceChanges"
#property indicator_type1   DRAW_HISTOGRAM
#property indicator_color1  clrBlueViolet

//--- UpperLevel Plot 
#property indicator_label2  "u_Level"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrRed

//--- LowerLevel Plot
#property indicator_label3  "l_Level"
#property indicator_type3   DRAW_LINE
#property indicator_color3  clrGreen

//--- ZeroLevel
#property indicator_level1 0
#property indicator_levelcolor clrBlueViolet

//--- Importing Moving Average
#include <MovingAverages.mqh>

//---inputs
input int      MaPeriod    = 3;     // Moving average period
input double   Coefficient = 1.618; // Confidence coefficient
input int      MinCriteria = 300;   // Signal Criteria (EA usage only)
input int      MaxCriteria = 2000;  // Signal Criteria (EA usage only)

//--- buffers
double   AbsolutePriceChangesBuffer[];
double   PriceChangesBuffer[];
double   u_CLevelBuffer[];
double   l_CLevelBuffer[];
double   EAsignal[];

//--- global variables
int      startpoint     = MaPeriod-1;
double   umincriteria   = MinCriteria*_Point;
double   lmincriteria   = -1*umincriteria;
double   umaxcriteria   = MaxCriteria*_Point;
double   lmaxcriteria   = -1*umaxcriteria;

//---initialization----------------------------------------------+
int OnInit()
  {
//--- main buffers
   SetIndexBuffer(0,PriceChangesBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,u_CLevelBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,l_CLevelBuffer,INDICATOR_DATA);
   
//--- secondary buffer for calculation
   SetIndexBuffer(3,AbsolutePriceChangesBuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,EAsignal,INDICATOR_CALCULATIONS);
   
//---
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,startpoint);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,startpoint);
   
//--- name of indicator
   string name=  "InverseReaction ("+IntegerToString(MaPeriod)+" , "+DoubleToString(Coefficient,3)+")"; 
   IndicatorSetString(INDICATOR_SHORTNAME,name);

//---
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);

//---
   return(INIT_SUCCEEDED);
  }  
//---iteration function-------------------------------------------+

int OnCalculate(const int rates_total,const int prev_calculated,const datetime &time[],
                const double &open[],const double &high[],const double &low[],const double &close[],
                const long &tick_volume[],const long &volume[],const int &spread[])
  {

   if(rates_total<MaPeriod) 
     {   Print("Sorry!!, there is not enough bars. Download more historical data and retry");
         return(0);
     }
//--- Gap free price changes
   for(int i=1;i<rates_total;i++)
     {   PriceChangesBuffer[i]=(close[i]-open[i]);
         AbsolutePriceChangesBuffer[i]=fabs(PriceChangesBuffer[i]);
     } 
//--- Dynamic Confidence Levels (DCL)--------------------------------------------------------------------------------
      //
      // To determine DCLs, first, moving standard deviation (MStD) must be calculated. With the assumption of 
      // "PERFECT NORMALITY CONDITIONS" in price changes, and using absolute values with "HALF NORMAL" 
      // distribution method, MStD can be calculated by MA:
      // Ex:---------------------------------------------------| 
      // |    MStD = Sqrt[Pi]/Sqrt[2] * MA[Abs[Price Changes]] |
      // |    GoldenRatio ~= z[%80] * Sqrt[Pi]/Sqrt[2]         |
      // |    DCL[%80]~= GoldenRatio * MA[Abs[Price Changes]]  |
      // |-----------------------------------------------------|
      // With large numbers of MaPeriod, DCL aproximates to static ConfidenceLevel for normal distribution, 
      // However the system is dynamic and memory is very short for such economic behavours, 
      // so it set with a small number: 3 as default. (!!! plus, considering a possible HEAVY-TAIL problem, 
      // small values of MaPeriod will relatively response better.) 
      // ---------------------------------------------------------------------------------------------------------- 
   for(int i=startpoint;i<rates_total;i++)
     {   u_CLevelBuffer[i]=Coefficient*SimpleMA(i,MaPeriod,AbsolutePriceChangesBuffer);
         l_CLevelBuffer[i]=-1*u_CLevelBuffer[i];
     }
      
//--- Signal buffer !!!FOR EXPERT ADVISOR!!!
   for(int i=MaPeriod;i<rates_total;i++)  
     {   if(PriceChangesBuffer[i-1]>u_CLevelBuffer[i-1] 
                  && PriceChangesBuffer[i-1]>umincriteria
                  && PriceChangesBuffer[i-1]<umaxcriteria) EAsignal[i]=1;
         else if(PriceChangesBuffer[i-1]<l_CLevelBuffer[i-1] 
                  && PriceChangesBuffer[i-1]<lmincriteria 
                  && PriceChangesBuffer[i-1]>lmaxcriteria) EAsignal[i]=-1;
         else EAsignal[i]=0.0;
     } 
//---
   return(rates_total);
  }
//+------------------------------------------------------------------+