//+------------------------------------------------------------------+
//|                                    i-SpectrAnalysis_MA_Cloud.mq5 |
//|                                           Copyright  2006, klot |
//|                                                     klot@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, klot"
#property link      "klot@mail.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrPaleGreen,clrHotPink
//----   
#property indicator_label1  "i-SpectrAnalysis_MA_Cloud"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                //        
//+----------------------------------------------+
//|   dt_FFT.mqh               |
//+----------------------------------------------+
#include <dt_FFT.mqh> 
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint   MAPeriod=13;
input  ENUM_MA_METHOD   MAType=MODE_EMA;
input ENUM_APPLIED_PRICE   MAPrice=PRICE_CLOSE;
input uint N = 7;   //  
input uint SS = 20; //  
input int Shift=0;  //      
//+----------------------------------------------+
//----   ,    
//----      
double ExtSpanABuffer[],ExtSpanBBuffer[];
int M,tnn1,ss;
//----
double aa[],bb[];
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+   
//| i-SpectrAnalysis_MA indicator initialization function            |
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   tnn1=int(MathPow(2,N));
   M=ArrayResize(aa,tnn1+1);
   ArraySetAsSeries(aa,true);
   ArrayResize(bb,tnn1+1);
   ArraySetAsSeries(bb,true);
   ss=int(MathMin(SS,M));
   min_rates_total=int(M+MAPeriod);
//---    iMA
   Ind_Handle=iMA(Symbol(),PERIOD_CURRENT,MAPeriod,0,MAType,MAPrice);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,ExtSpanABuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtSpanABuffer,true);
//----      
   SetIndexBuffer(1,ExtSpanBBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(ExtSpanBBuffer,true);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       InpKijun
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"i-SpectrAnalysis_MA_Cloud");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| i-SpectrAnalysis_MA iteration function                           |
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total || BarsCalculated(Ind_Handle)<rates_total) return(RESET);
//----
   for(int bar=rates_total-1; bar>=prev_calculated && !IsStopped(); bar--) ExtSpanABuffer[bar]=0.0;
   for(int bar=rates_total-1; bar>=prev_calculated && !IsStopped(); bar--) ExtSpanBBuffer[bar]=0.0;
//---      
   if(CopyBuffer(Ind_Handle,0,0,M,aa)<=0) return(RESET);
//----
   int end=M-1;
   fastcosinetransform(aa,tnn1,false);
   for(int kkk=0; kkk<=end && !IsStopped(); kkk++) if(kkk>=ss) aa[kkk]=0.0;
   fastcosinetransform(aa,tnn1,true);
   for(int rrr=0; rrr<=end && !IsStopped(); rrr++) ExtSpanBBuffer[rrr]=aa[rrr];
//----
   for(int iii=M-1; iii>=0 && !IsStopped(); iii--) bb[iii]=close[rates_total-1-iii];
   fastcosinetransform(bb,tnn1,false);
   for(int kkk=0; kkk<=end && !IsStopped(); kkk++) if(kkk>=ss) bb[kkk]=0.0;
   fastcosinetransform(bb,tnn1,true);
   for(int rrr=0; rrr<=end && !IsStopped(); rrr++) ExtSpanABuffer[rrr]=bb[rrr];
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
